/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.listeners;

import net.thenextlvl.utilities.UtilitiesPlugin;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public final class SlimeListener
implements Listener {
    private final UtilitiesPlugin plugin;

    public SlimeListener(UtilitiesPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerSlimePiston(PlayerInteractEvent event) {
        Piston piston;
        BlockData blockData;
        if (!this.plugin.config().pistonSliming()) {
            return;
        }
        if (event.getPlayer().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!event.getMaterial().equals((Object)Material.SLIME_BALL) || !EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        BlockData blockData2 = block.getBlockData();
        if (!(blockData2 instanceof Directional)) {
            return;
        }
        Directional face = (Directional)blockData2;
        if (!face.getFacing().equals((Object)event.getBlockFace())) {
            return;
        }
        if (block.getType().equals((Object)Material.PISTON_HEAD)) {
            PistonHead head = (PistonHead)block.getBlockData();
            if (head.getType().equals((Object)TechnicalPiston.Type.STICKY)) {
                return;
            }
            head.setType(TechnicalPiston.Type.STICKY);
            block.setBlockData((BlockData)head, false);
        } else if (block.getType().equals((Object)Material.PISTON) && (blockData = block.getBlockData()) instanceof Piston && !(piston = (Piston)blockData).isExtended()) {
            block.setBlockData(Material.STICKY_PISTON.createBlockData(data -> {
                if (data instanceof Directional) {
                    Directional directional = (Directional)data;
                    directional.setFacing(face.getFacing());
                }
            }), true);
        } else {
            return;
        }
        event.getPlayer().swingMainHand();
        event.getPlayer().playSound(block.getLocation(), Sound.BLOCK_SLIME_BLOCK_PLACE, 1.0f, 1.0f);
        if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        if (event.getItem() != null) {
            event.getItem().subtract();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerShearPiston(PlayerInteractEvent event) {
        Piston piston;
        BlockData blockData;
        if (!this.plugin.config().pistonSliming()) {
            return;
        }
        if (event.getPlayer().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!event.getMaterial().equals((Object)Material.SHEARS) || !EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        BlockData blockData2 = block.getBlockData();
        if (!(blockData2 instanceof Directional)) {
            return;
        }
        Directional face = (Directional)blockData2;
        if (!face.getFacing().equals((Object)event.getBlockFace())) {
            return;
        }
        if (block.getType().equals((Object)Material.PISTON_HEAD)) {
            PistonHead head = (PistonHead)block.getBlockData();
            if (head.getType().equals((Object)TechnicalPiston.Type.NORMAL)) {
                return;
            }
            head.setType(TechnicalPiston.Type.NORMAL);
            block.setBlockData((BlockData)head, false);
        } else if (block.getType().equals((Object)Material.STICKY_PISTON) && (blockData = block.getBlockData()) instanceof Piston && !(piston = (Piston)blockData).isExtended()) {
            block.setBlockData(Material.PISTON.createBlockData(data -> {
                if (data instanceof Directional) {
                    Directional directional = (Directional)data;
                    directional.setFacing(piston.getFacing());
                }
            }), true);
        } else {
            return;
        }
        event.getPlayer().swingMainHand();
        event.getPlayer().playSound(block.getLocation(), Sound.BLOCK_SLIME_BLOCK_BREAK, 1.0f, 1.0f);
        if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        if (event.getItem() != null) {
            event.getItem().damage(1, (LivingEntity)event.getPlayer());
        }
    }
}

