/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.listeners;

import net.thenextlvl.utilities.utils.Settings;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public final class OpenableListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!Settings.get(event.getPlayer(), Settings.HAND_OPENABLE)) {
            return;
        }
        if (!EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getItem() != null && event.getItem().getType().isBlock()) {
            return;
        }
        if (event.getItem() != null && event.getItem().getType().equals((Object)Material.DEBUG_STICK)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !block.getType().equals((Object)Material.IRON_DOOR) && !block.getType().equals((Object)Material.IRON_TRAPDOOR)) {
            return;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Openable)) {
            return;
        }
        Openable openable = (Openable)blockData;
        block.getWorld().playSound(block.getLocation(), this.getSound(openable, block.getType()), 1.0f, 1.0f);
        event.setUseItemInHand(Event.Result.DENY);
        openable.setOpen(!openable.isOpen());
        block.setBlockData((BlockData)openable, false);
        event.getPlayer().swingMainHand();
        event.setCancelled(true);
    }

    private Sound getSound(Openable openable, Material material) {
        return openable.isOpen() ? (material.equals((Object)Material.IRON_DOOR) ? Sound.BLOCK_IRON_DOOR_CLOSE : Sound.BLOCK_IRON_TRAPDOOR_CLOSE) : (material.equals((Object)Material.IRON_DOOR) ? Sound.BLOCK_IRON_DOOR_OPEN : Sound.BLOCK_IRON_TRAPDOOR_OPEN);
    }
}

