/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.listeners;

import java.util.Optional;
import net.thenextlvl.utilities.UtilitiesPlugin;
import net.thenextlvl.utilities.listeners.AdvancedFlyListener;
import net.thenextlvl.utilities.listeners.AirPlacingListener;
import net.thenextlvl.utilities.utils.Settings;
import org.bukkit.attribute.Attribute;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public final class ConnectionListener
implements Listener {
    private final UtilitiesPlugin plugin;

    public ConnectionListener(UtilitiesPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Settings.set(event.getPlayer(), Settings.HAND_OPENABLE, true);
        Settings.set(event.getPlayer(), Settings.SLAB_PART_BREAKING, true);
        Optional.ofNullable(event.getPlayer().getAttribute(Attribute.ATTACK_SPEED)).ifPresent(attribute -> {
            double value = this.plugin.config().fixAttackSpeed() ? 1024.0 : attribute.getDefaultValue();
            attribute.setBaseValue(value);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        AdvancedFlyListener.lastVelocity.remove(event.getPlayer());
        AdvancedFlyListener.slower1.remove(event.getPlayer());
        AdvancedFlyListener.slower2.remove(event.getPlayer());
        AirPlacingListener.targetBlocks.remove(event.getPlayer());
        Settings.invalidate(event.getPlayer());
    }
}

