/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.listeners;

import net.thenextlvl.utilities.utils.Settings;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.util.RayTraceResult;

public final class BlockBreakListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSlabBreak(BlockBreakEvent event) {
        if (!Settings.get(event.getPlayer(), Settings.SLAB_PART_BREAKING)) {
            return;
        }
        BlockData blockData = event.getBlock().getBlockData();
        if (!(blockData instanceof Slab)) {
            return;
        }
        Slab slab = (Slab)blockData;
        if (!slab.getType().equals((Object)Slab.Type.DOUBLE)) {
            return;
        }
        slab.setType(this.isTopHalf(event.getPlayer()) ? Slab.Type.BOTTOM : Slab.Type.TOP);
        event.getBlock().setBlockData((BlockData)slab, false);
        event.setCancelled(true);
    }

    private boolean isTopHalf(Player player) {
        AttributeInstance range = player.getAttribute(Attribute.BLOCK_INTERACTION_RANGE);
        RayTraceResult result = player.rayTraceBlocks(range != null ? range.getValue() : 6.0);
        if (result == null || result.getHitBlockFace() == null) {
            return false;
        }
        if (result.getHitBlockFace().equals((Object)BlockFace.DOWN)) {
            return false;
        }
        if (result.getHitBlockFace().equals((Object)BlockFace.UP)) {
            return true;
        }
        return (double)Math.round(result.getHitPosition().getY()) > result.getHitPosition().getY();
    }
}

