/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.listeners;

import java.util.HashMap;
import java.util.Map;
import net.thenextlvl.utilities.utils.Settings;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public final class AirPlacingListener
implements Listener {
    static final Map<Player, Location> targetBlocks = new HashMap<Player, Location>();
    private final BlockData blockData = Material.BARRIER.createBlockData();
    private final BlockData waterlogged = Material.BARRIER.createBlockData(data -> ((Waterlogged)data).setWaterlogged(true));

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!Settings.get(player, Settings.AIR_PLACING)) {
            this.hideBlock(player);
            return;
        }
        if (player.getInventory().getItemInMainHand().isEmpty() && player.getInventory().getItemInOffHand().isEmpty()) {
            this.hideBlock(player);
            return;
        }
        AttributeInstance range = player.getAttribute(Attribute.BLOCK_INTERACTION_RANGE);
        if (range == null || player.getTargetBlockExact((int)range.getValue()) != null) {
            this.hideBlock(player);
            return;
        }
        Location eyeLocation = player.getEyeLocation();
        Location targetBlock = eyeLocation.add(eyeLocation.getDirection().multiply(range.getValue()));
        Location lastTarget = targetBlocks.put(player, targetBlock);
        boolean isWater = targetBlock.getBlock().getType().equals((Object)Material.WATER);
        if (!isWater && !targetBlock.getBlock().isEmpty() || targetBlock.equals((Object)lastTarget)) {
            return;
        }
        if (lastTarget != null) {
            player.sendBlockChange(lastTarget, lastTarget.getBlock().getBlockData());
        }
        if (event.getFrom().distanceSquared(event.getTo()) > 0.5) {
            return;
        }
        player.sendBlockChange(targetBlock, isWater ? this.waterlogged : this.blockData);
    }

    private void hideBlock(Player player) {
        targetBlocks.computeIfPresent(player, (entry, location) -> {
            entry.sendBlockChange(location, location.getBlock().getBlockData());
            return null;
        });
    }
}

