/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.interfaces.pottery;

import core.paper.gui.PaginatedGUI;
import core.paper.item.ActionItem;
import core.paper.item.ItemBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.PotDecorations;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.utilities.UtilitiesPlugin;
import net.thenextlvl.utilities.interfaces.pottery.PotteryDesignerGUI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jspecify.annotations.Nullable;

public final class SherdSelectorGUI
extends PaginatedGUI<UtilitiesPlugin, Material> {
    private static final List<Material> sherds = List.of(Material.ANGLER_POTTERY_SHERD, Material.ARCHER_POTTERY_SHERD, Material.ARMS_UP_POTTERY_SHERD, Material.BLADE_POTTERY_SHERD, Material.BREWER_POTTERY_SHERD, Material.BURN_POTTERY_SHERD, Material.DANGER_POTTERY_SHERD, Material.EXPLORER_POTTERY_SHERD, Material.FLOW_POTTERY_SHERD, Material.FRIEND_POTTERY_SHERD, Material.GUSTER_POTTERY_SHERD, Material.HEART_POTTERY_SHERD, Material.HEARTBREAK_POTTERY_SHERD, Material.HOWL_POTTERY_SHERD, Material.MINER_POTTERY_SHERD, Material.MOURNER_POTTERY_SHERD, Material.PLENTY_POTTERY_SHERD, Material.PRIZE_POTTERY_SHERD, Material.SCRAPE_POTTERY_SHERD, Material.SHEAF_POTTERY_SHERD, Material.SHELTER_POTTERY_SHERD, Material.SKULL_POTTERY_SHERD, Material.SNORT_POTTERY_SHERD);
    private final PaginatedGUI.Pagination pagination;
    private final ItemStack pot;
    private final PotteryDesignerGUI.Side side;

    public SherdSelectorGUI(UtilitiesPlugin plugin, Player owner, ItemStack pot, PotteryDesignerGUI.Side side) {
        super(plugin, owner, plugin.bundle().component("gui.title.pottery.sherd", (Audience)owner), 5);
        IntStream slots = IntStream.of(19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34);
        this.pagination = new PaginatedGUI.Pagination(slots.toArray(), 3, 5);
        this.pot = pot;
        this.side = side;
        this.loadPage(this.getCurrentPage());
    }

    @Override
    public void pageLoaded() {
        this.setSlot(1, ItemBuilder.of(Material.PLAYER_HEAD).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.randomize", (Audience)this.owner)).profileValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzk3OTU1NDYyZTRlNTc2NjY0NDk5YWM0YTFjNTcyZjYxNDNmMTlhZDJkNjE5NDc3NjE5OGY4ZDEzNmZkYjIifX19").withAction(player -> {
            PotDecorations data = (PotDecorations)this.pot.getData(DataComponentTypes.POT_DECORATIONS);
            if (data != null) {
                this.pot.setData(DataComponentTypes.POT_DECORATIONS, (Object)SherdSelectorGUI.decorate(this.side, data, SherdSelectorGUI.getRandomSherd(sherds.size())));
            }
            new PotteryDesignerGUI((UtilitiesPlugin)this.plugin, this.owner, this.pot).open();
        }));
        this.setSlot(4, ItemBuilder.of(this.pot).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.pottery", (Audience)this.owner)).lore(new Component[]{Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.pottery.get", (Audience)this.owner)}).withAction(player -> player.getInventory().addItem(new ItemStack[]{this.pot})));
        this.setSlot(7, ItemBuilder.of(Material.BARRIER).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.back", (Audience)this.owner)).withAction(player -> new PotteryDesignerGUI((UtilitiesPlugin)this.plugin, this.owner, this.pot).open()));
        super.pageLoaded();
    }

    @Override
    public ActionItem constructItem(Material sherd) {
        return ItemBuilder.of(sherd).itemName((Component)Component.translatable((String)sherd.translationKey(), (TextColor)NamedTextColor.GOLD)).withAction(player -> {
            PotDecorations data = (PotDecorations)this.pot.getData(DataComponentTypes.POT_DECORATIONS);
            if (data != null) {
                this.pot.setData(DataComponentTypes.POT_DECORATIONS, (Object)SherdSelectorGUI.decorate(this.side, data, sherd.asItemType()));
            }
            new PotteryDesignerGUI((UtilitiesPlugin)this.plugin, this.owner, this.pot).open();
        });
    }

    static PotDecorations decorate(PotteryDesignerGUI.Side side, PotDecorations data, @Nullable ItemType sherd) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case PotteryDesignerGUI.Side.BACK -> PotDecorations.potDecorations((ItemType)sherd, (ItemType)data.left(), (ItemType)data.right(), (ItemType)data.front());
            case PotteryDesignerGUI.Side.FRONT -> PotDecorations.potDecorations((ItemType)data.back(), (ItemType)data.left(), (ItemType)data.right(), (ItemType)sherd);
            case PotteryDesignerGUI.Side.LEFT -> PotDecorations.potDecorations((ItemType)data.back(), (ItemType)sherd, (ItemType)data.right(), (ItemType)data.front());
            case PotteryDesignerGUI.Side.RIGHT -> PotDecorations.potDecorations((ItemType)data.back(), (ItemType)data.left(), (ItemType)sherd, (ItemType)data.front());
        };
    }

    @Override
    protected void formatDefault() {
        ItemBuilder placeholder = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip();
        IntStream.range(0, this.getSize()).forEach(slot -> this.setSlotIfAbsent(slot, placeholder));
    }

    @Override
    public Component getPageFormat(int page) {
        String message = this.getCurrentPage() < page ? "gui.page.next" : "gui.page.previous";
        return ((UtilitiesPlugin)this.plugin).bundle().component(message, (Audience)this.owner);
    }

    @Override
    public Collection<Material> getElements() {
        return sherds;
    }

    @Override
    public PaginatedGUI.Pagination getPagination() {
        return this.pagination;
    }

    static PotDecorations getRandom() {
        int max = sherds.size() + 5;
        return PotDecorations.potDecorations((ItemType)SherdSelectorGUI.getRandomSherd(max), (ItemType)SherdSelectorGUI.getRandomSherd(max), (ItemType)SherdSelectorGUI.getRandomSherd(max), (ItemType)SherdSelectorGUI.getRandomSherd(max));
    }

    static @Nullable ItemType getRandomSherd(int max) {
        int index = ThreadLocalRandom.current().nextInt(max);
        return index >= sherds.size() ? null : sherds.get(index).asItemType();
    }
}

