/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.interfaces.pottery;

import core.paper.gui.GUI;
import core.paper.item.ItemBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.PotDecorations;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.utilities.UtilitiesPlugin;
import net.thenextlvl.utilities.interfaces.pottery.SherdSelectorGUI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.Nullable;

public final class PotteryDesignerGUI
extends GUI<UtilitiesPlugin> {
    public PotteryDesignerGUI(UtilitiesPlugin plugin, Player owner, ItemStack pot) {
        super(plugin, owner, plugin.bundle().component("gui.title.pottery", (Audience)owner), 5);
        this.setSlot(10, ItemBuilder.of(Material.PLAYER_HEAD).itemName(plugin.bundle().component("gui.item.randomize", (Audience)owner)).profileValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzk3OTU1NDYyZTRlNTc2NjY0NDk5YWM0YTFjNTcyZjYxNDNmMTlhZDJkNjE5NDc3NjE5OGY4ZDEzNmZkYjIifX19").withAction(player -> {
            pot.setData(DataComponentTypes.POT_DECORATIONS, (Object)SherdSelectorGUI.getRandom());
            this.updatePot(pot);
        }));
        this.setSlot(16, ItemBuilder.of(Material.BARRIER).itemName(plugin.bundle().component("gui.item.close", (Audience)owner)).withAction(player -> player.getScheduler().execute((Plugin)plugin, () -> ((Player)player).closeInventory(), null, 1L)));
        this.updatePot(pot);
    }

    private void updatePot(ItemStack pot) {
        this.setSlot(22, ItemBuilder.of(pot).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.pottery", (Audience)this.owner)).lore(new Component[]{Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.pottery.get", (Audience)this.owner)}).withAction(player -> player.getInventory().addItem(new ItemStack[]{pot})));
        PotDecorations data = (PotDecorations)pot.getData(DataComponentTypes.POT_DECORATIONS);
        this.updateSlot(13, Side.BACK, pot, data);
        this.updateSlot(21, Side.LEFT, pot, data);
        this.updateSlot(23, Side.RIGHT, pot, data);
        this.updateSlot(31, Side.FRONT, pot, data);
    }

    private void updateSlot(int slot, Side side, ItemStack pot, @Nullable PotDecorations data) {
        ItemStack item = this.getItem(side, data);
        this.setSlot(slot, ItemBuilder.of(item != null ? item : ItemStack.of((Material)Material.BRICK)).itemName((Component)(item == null ? ((UtilitiesPlugin)this.plugin).bundle().component(side.name, (Audience)this.owner) : Component.translatable((String)item.translationKey(), (TextColor)NamedTextColor.GOLD))).lore(new Component[]{Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.pottery.set", (Audience)this.owner), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.pottery.remove", (Audience)this.owner)}).withAction((type, player) -> {
            if (type.isLeftClick()) {
                new SherdSelectorGUI((UtilitiesPlugin)this.plugin, this.owner, pot, side).open();
            } else if (type.isRightClick() && data != null) {
                PotDecorations decoration = SherdSelectorGUI.decorate(side, data, null);
                pot.setData(DataComponentTypes.POT_DECORATIONS, (Object)decoration);
                this.updatePot(pot);
            }
        }));
    }

    private @Nullable ItemStack getItem(Side side, @Nullable PotDecorations data) {
        if (data == null) {
            return null;
        }
        return switch (side.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (data.left() != null) {
                    yield data.left().createItemStack();
                }
                yield null;
            }
            case 1 -> {
                if (data.right() != null) {
                    yield data.right().createItemStack();
                }
                yield null;
            }
            case 3 -> {
                if (data.back() != null) {
                    yield data.back().createItemStack();
                }
                yield null;
            }
            case 2 -> data.front() != null ? data.front().createItemStack() : null;
        };
    }

    @Override
    protected void formatDefault() {
        ItemBuilder placeholder = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip();
        IntStream.range(0, this.getSize()).forEach(slot -> this.setSlotIfAbsent(slot, placeholder));
    }

    public static enum Side {
        LEFT("gui.item.pottery.left"),
        RIGHT("gui.item.pottery.right"),
        FRONT("gui.item.pottery.front"),
        BACK("gui.item.pottery.back");

        private final String name;

        private Side(String name) {
            this.name = name;
        }
    }
}

