/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.interfaces.banner;

import core.paper.gui.PaginatedGUI;
import core.paper.item.ActionItem;
import core.paper.item.ItemBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.thenextlvl.utilities.UtilitiesPlugin;
import net.thenextlvl.utilities.interfaces.banner.ColorGUI;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class PatternGUI
extends PaginatedGUI<UtilitiesPlugin, PatternType> {
    private static final short MAX_PATTERN_AMOUNT = 16;
    private final List<PatternType> patterns = RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).stream().filter(patternType -> !patternType.equals((Object)PatternType.BASE)).toList();
    private final PaginatedGUI.Pagination pagination;
    private final ItemStack banner;
    private final DyeColor color;

    public PatternGUI(UtilitiesPlugin plugin, Player owner, ItemStack banner, DyeColor color) {
        super(plugin, owner, plugin.bundle().component("gui.title.banner.pattern", (Audience)owner), 6);
        IntStream slots = IntStream.of(19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43);
        this.pagination = new PaginatedGUI.Pagination(slots.toArray(), 3, 5);
        this.banner = banner;
        this.color = color;
        this.loadPage(this.getCurrentPage());
    }

    @Override
    public void pageLoaded() {
        this.setSlot(1, ItemBuilder.of(Material.PLAYER_HEAD).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.randomize", (Audience)this.owner)).profileValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzk3OTU1NDYyZTRlNTc2NjY0NDk5YWM0YTFjNTcyZjYxNDNmMTlhZDJkNjE5NDc3NjE5OGY4ZDEzNmZkYjIifX19").withAction(player -> player.getScheduler().execute(this.plugin, () -> {
            PatternType pattern = this.patterns.get(ThreadLocalRandom.current().nextInt(0, this.patterns.size()));
            this.giveOrContinue(this.applyPattern(this.banner.clone(), pattern, this.color));
        }, null, 1L)));
        this.setSlot(4, ItemBuilder.of(this.banner.clone()).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.banner", (Audience)this.owner)).lore(new Component[]{Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.banner.click", (Audience)this.owner)}).withAction(player -> {
            player.playSound((Entity)player, Sound.UI_LOOM_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.getInventory().addItem(new ItemStack[]{this.banner});
        }));
        this.setSlot(7, ItemBuilder.of(Material.BARRIER).itemName(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.back", (Audience)this.owner)).withAction(player -> new ColorGUI((UtilitiesPlugin)this.plugin, player, this.banner).open()));
        super.pageLoaded();
    }

    @Override
    public ActionItem constructItem(PatternType element) {
        NamespacedKey key = RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).getKey((Keyed)element);
        String title = key != null ? "gui.item.banner.pattern." + key.value() : "gui.item.banner.pattern.unknown";
        ItemStack item = this.applyPattern(this.banner.clone(), element, this.color);
        return ItemBuilder.of(item.clone()).itemName(((UtilitiesPlugin)this.plugin).bundle().component(title, (Audience)this.owner)).lore(new Component[]{Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.banner.color.click", (Audience)this.owner)}).withAction(player -> player.getScheduler().execute(this.plugin, () -> this.giveOrContinue(item), null, 1L));
    }

    private void giveOrContinue(ItemStack banner) {
        BannerPatternLayers data = (BannerPatternLayers)banner.getData(DataComponentTypes.BANNER_PATTERNS);
        if (data == null || data.patterns().size() >= 16) {
            ((UtilitiesPlugin)this.plugin).bundle().sendMessage((Audience)this.owner, "banner.patterns.maximum");
            this.owner.playSound((Entity)this.owner, Sound.UI_LOOM_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.owner.getInventory().addItem(new ItemStack[]{banner});
            this.owner.getInventory().close();
        } else {
            this.owner.playSound((Entity)this.owner, Sound.UI_LOOM_SELECT_PATTERN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            new ColorGUI((UtilitiesPlugin)this.plugin, this.owner, banner).open();
        }
    }

    private ItemStack applyPattern(ItemStack banner, PatternType pattern, DyeColor color) {
        BannerPatternLayers data = (BannerPatternLayers)banner.getData(DataComponentTypes.BANNER_PATTERNS);
        if (data == null) {
            return banner;
        }
        BannerPatternLayers patterns = (BannerPatternLayers)BannerPatternLayers.bannerPatternLayers().addAll(data.patterns()).add(new Pattern(color, pattern)).build();
        banner.setData(DataComponentTypes.BANNER_PATTERNS, (Object)patterns);
        return banner;
    }

    @Override
    protected void formatDefault() {
        ItemBuilder placeholder = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip();
        IntStream.range(0, this.getSize()).forEach(slot -> this.setSlotIfAbsent(slot, placeholder));
    }

    @Override
    public Component getPageFormat(int page) {
        String message = this.getCurrentPage() < page ? "gui.page.next" : "gui.page.previous";
        return ((UtilitiesPlugin)this.plugin).bundle().component(message, (Audience)this.owner);
    }

    @Override
    public Collection<PatternType> getElements() {
        return this.patterns;
    }

    @Override
    public PaginatedGUI.Pagination getPagination() {
        return this.pagination;
    }
}

