/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.interfaces;

import core.paper.gui.GUI;
import core.paper.item.ItemBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.thenextlvl.utilities.UtilitiesPlugin;
import net.thenextlvl.utilities.utils.Settings;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.Nullable;

public final class UtilitiesGUI
extends GUI<UtilitiesPlugin> {
    private final PotionEffect nightVision = new PotionEffect(PotionEffectType.NIGHT_VISION, -1, 0, true, false);

    public UtilitiesGUI(UtilitiesPlugin plugin, Player owner) {
        super(plugin, owner, plugin.bundle().component("gui.title.utilities", (Audience)owner), 3);
        this.updateIronInteraction();
        this.updateCustomSlabBreaking();
        this.updateAirPlacing();
        this.updateNightVision();
        this.updateNoClip();
        this.updateAdvancedFly();
    }

    private void updateIronInteraction() {
        this.updateFeature(10, Material.IRON_TRAPDOOR, "gui.item.iron-trapdoor-interaction", "gui.item.iron-trapdoor-interaction.description", "builders.util.trapdoor", Settings.HAND_OPENABLE);
    }

    private void updateCustomSlabBreaking() {
        this.updateFeature(11, Material.STONE_SLAB, "gui.item.custom-slab-breaking", "gui.item.custom-slab-breaking.description", "builders.util.slabs", Settings.SLAB_PART_BREAKING);
    }

    private void updateAirPlacing() {
        this.updateFeature(12, Material.STRUCTURE_VOID, "gui.item.air-placing", "gui.item.air-placing.description", "builders.util.air-placing", Settings.AIR_PLACING);
    }

    private void updateNightVision() {
        this.updateFeature(14, Material.ENDER_EYE, "gui.item.nightvision", "gui.item.nightvision.description", "builders.util.night-vision", this.owner.hasPotionEffect(PotionEffectType.NIGHT_VISION), state -> {
            if (state.booleanValue()) {
                this.owner.addPotionEffect(this.nightVision);
            } else {
                this.owner.removePotionEffect(PotionEffectType.NIGHT_VISION);
            }
        });
    }

    private void updateNoClip() {
        this.updateFeature(15, Material.COMPASS, "gui.item.noclip", "gui.item.noclip.description", "builders.util.no-clip", Settings.NO_CLIP);
    }

    private void updateAdvancedFly() {
        this.updateFeature(16, Material.FEATHER, "gui.item.advancedfly", "gui.item.advancedfly.description", "builders.util.advanced-fly", Settings.ADVANCED_FLY);
    }

    private void updateFeature(int slot, Material icon, String title, String description, String permission, Settings setting) {
        this.updateFeature(slot, icon, title, description, permission, Settings.get(this.owner, setting), state -> Settings.set(this.owner, setting, state));
    }

    private void updateFeature(int slot, Material icon, String title, String description, String permission, boolean enabled, Consumer<Boolean> setter) {
        ItemBuilder item = ItemBuilder.of(icon).itemName(((UtilitiesPlugin)this.plugin).bundle().component(title, (Audience)this.owner));
        if (!this.owner.hasPermission(permission)) {
            this.setSlot(slot, item.lore(((UtilitiesPlugin)this.plugin).bundle().component("gui.item.permission", (Audience)this.owner)));
            this.updateState(slot, null);
            return;
        }
        this.setSlot(slot, item.lore(new Component[]{((UtilitiesPlugin)this.plugin).bundle().component("gui.state", (Audience)this.owner, Formatter.booleanChoice((String)"state", (boolean)enabled)), Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.toggle.click", (Audience)this.owner), Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component(description, (Audience)this.owner).applyFallbackStyle(new StyleBuilderApplicable[]{TextDecoration.ITALIC.withState(false)}).colorIfAbsent((TextColor)NamedTextColor.DARK_GRAY)}).withAction((type, player) -> {
            if (type.equals((Object)ClickType.DOUBLE_CLICK)) {
                return;
            }
            setter.accept(!enabled);
            this.updateFeature(slot, icon, title, description, permission, !enabled, setter);
        }));
        this.updateState(slot, enabled);
    }

    private void updateState(int slot, @Nullable Boolean state) {
        ItemStack item = ItemStack.of((Material)(state == null ? Material.ORANGE_STAINED_GLASS_PANE : (state != false ? Material.GREEN_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE)));
        item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build()));
        this.setSlot(slot - 9, item);
        this.setSlot(slot + 9, item);
    }

    @Override
    protected void formatDefault() {
    }
}

