/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.interfaces;

import core.paper.gui.GUI;
import core.paper.item.ItemBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import java.util.Random;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.thenextlvl.utilities.UtilitiesPlugin;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public final class ArmorCreatorGUI
extends GUI<UtilitiesPlugin> {
    private static final String DICE_RED = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTEzMWRlOGU5NTFmZGQ3YjlhM2QyMzlkN2NjM2FhM2U4NjU1YTMzNmI5OTliOWVkYmI0ZmIzMjljYmQ4NyJ9fX0=";
    private static final String DICE_GREEN = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWMzY2VjNjg3NjlmZTljOTcxMjkxZWRiN2VmOTZhNGUzYjYwNDYyY2ZkNWZiNWJhYTFjYmIzYTcxNTEzZTdiIn19fQ==";
    private static final String DICE_BLUE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjMyOGYzNzhmMjhhOTg3MjIyNmY1Y2UwNGQ2ZTFkZmExMTE2MTg1ODdmNDhkZmExZmU4MmQwNDMyMTZhNWNmIn19fQ==";
    private static final String SOLID_RED = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2Y0NmMzMWQ2ZWU2ZWE2MTlmNzJlNzg1MjMyY2IwNDhhYjI3MDQ2MmRiMGNiMTQ1NDUxNDQzNjI1MWMxYSJ9fX0=";
    private static final String SOLID_GREEN = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzZmNjlmN2I3NTM4YjQxZGMzNDM5ZjM2NThhYmJkNTlmYWNjYTM2NmYxOTBiY2YxZDZkMGEwMjZjOGY5NiJ9fX0=";
    private static final String SOLID_BLUE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjgzOWUzODFkOWZlZGFiNmY4YjU5Mzk2YTI3NjQyMzhkY2ViMmY3ZWVhODU2ZGM2ZmM0NDc2N2RhMzgyZjEifX19";
    private final Random random = new Random();
    private int red = 10;
    private int green = 10;
    private int blue = 10;

    public ArmorCreatorGUI(UtilitiesPlugin plugin, Player owner) {
        super(plugin, owner, plugin.bundle().component("gui.title.armor-color-creator", (Audience)owner), 6);
        this.updateDices();
        this.updateSelector();
        this.updateArmor();
    }

    private void updateDices() {
        this.updateDice(22, DICE_RED, "gui.item.color.randomize.red", () -> {
            this.red = this.random.nextInt(0, 21);
        });
        this.updateDice(23, DICE_GREEN, "gui.item.color.randomize.green", () -> {
            this.green = this.random.nextInt(0, 21);
        });
        this.updateDice(24, DICE_BLUE, "gui.item.color.randomize.blue", () -> {
            this.blue = this.random.nextInt(0, 21);
        });
    }

    private void updateDice(int slot, String head, String name, Runnable randomization) {
        this.setSlot(slot, ItemBuilder.of(Material.PLAYER_HEAD).itemName(((UtilitiesPlugin)this.plugin).bundle().component(name, (Audience)this.owner)).profileValue(head).withAction((type, player) -> {
            if (type.equals((Object)ClickType.DOUBLE_CLICK)) {
                return;
            }
            randomization.run();
            this.updateSelector();
            this.updateArmor();
        }));
    }

    private void updateSelector() {
        this.updateSelector(31, this.red, Material.RED_STAINED_GLASS, SOLID_RED, "gui.item.color.red", amount -> {
            this.red = amount;
        });
        this.updateSelector(32, this.green, Material.GREEN_STAINED_GLASS, SOLID_GREEN, "gui.item.color.green", amount -> {
            this.green = amount;
        });
        this.updateSelector(33, this.blue, Material.BLUE_STAINED_GLASS, SOLID_BLUE, "gui.item.color.blue", amount -> {
            this.blue = amount;
        });
    }

    private void updateSelector(int slot, int amount, Material fallback, String head, String name, Consumer<Integer> setter) {
        ItemBuilder item = amount == 0 ? ItemBuilder.of(fallback) : ItemBuilder.of(Material.PLAYER_HEAD).profileValue(head).amount(amount);
        this.setSlot(slot, item.itemName(((UtilitiesPlugin)this.plugin).bundle().component(name, (Audience)this.owner)).lore(new Component[]{Component.empty(), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.color.left", (Audience)this.owner), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.color.right", (Audience)this.owner), ((UtilitiesPlugin)this.plugin).bundle().component("gui.item.color.shift", (Audience)this.owner)}).withAction((type, player) -> {
            int newAmount = Math.clamp((long)(amount + (switch (type) {
                case ClickType.LEFT -> 1;
                case ClickType.RIGHT -> -1;
                case ClickType.SHIFT_LEFT -> 5;
                case ClickType.SHIFT_RIGHT -> -5;
                default -> 0;
            })), 0, 20);
            if (amount == newAmount) {
                return;
            }
            setter.accept(newAmount);
            this.updateSelector(slot, newAmount, fallback, head, name, setter);
            this.updateArmor();
        }));
    }

    private void updateArmor() {
        this.updateArmor(10, Material.LEATHER_HELMET);
        this.updateArmor(19, Material.LEATHER_CHESTPLATE);
        this.updateArmor(28, Material.LEATHER_LEGGINGS);
        this.updateArmor(37, Material.LEATHER_BOOTS);
    }

    private void updateArmor(int slot, Material material) {
        ItemBuilder builder = ItemBuilder.of(material);
        Color color = Color.fromRGB((int)(this.red * 255 / 20), (int)(this.green * 255 / 20), (int)(this.blue * 255 / 20));
        DyedItemColor dye = (DyedItemColor)DyedItemColor.dyedItemColor().color(color).build();
        this.setSlot(slot, builder.data(DataComponentTypes.DYED_COLOR, dye).withAction(player -> player.getInventory().addItem(new ItemStack[]{builder.item()})));
    }

    @Override
    protected void formatDefault() {
    }
}

