/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.utilities.UtilitiesPlugin;
import net.thenextlvl.utilities.commands.brigadier.SimpleCommand;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class NightVisionCommand
extends SimpleCommand {
    private static final PotionEffect nightVision = new PotionEffect(PotionEffectType.NIGHT_VISION, -1, 0, true, false);

    private NightVisionCommand(UtilitiesPlugin plugin) {
        super(plugin, plugin.commands().nightVision, "builders.util.night-vision");
    }

    public static LiteralCommandNode<CommandSourceStack> create(UtilitiesPlugin plugin) {
        NightVisionCommand command = new NightVisionCommand(plugin);
        return ((LiteralArgumentBuilder)command.create().executes((Command)command)).build();
    }

    @Override
    protected boolean canUse(CommandSourceStack source) {
        return super.canUse(source) && source.getSender() instanceof Player;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String message = NightVisionCommand.toggleNightVision(player) ? "command.night-vision.enabled" : "command.night-vision.disabled";
        this.plugin.bundle().sendMessage((Audience)player, message);
        return 1;
    }

    private static boolean toggleNightVision(Player player) {
        if (player.hasPotionEffect(PotionEffectType.NIGHT_VISION)) {
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
            return false;
        }
        player.addPotionEffect(nightVision);
        return true;
    }
}

