/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities;

import core.file.formats.GsonFile;
import dev.faststats.bukkit.BukkitMetrics;
import dev.faststats.core.ErrorTracker;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import net.thenextlvl.i18n.ComponentBundle;
import net.thenextlvl.utilities.commands.AdvancedFlyCommand;
import net.thenextlvl.utilities.commands.AirPlaceCommand;
import net.thenextlvl.utilities.commands.BannerCommand;
import net.thenextlvl.utilities.commands.ColorCommand;
import net.thenextlvl.utilities.commands.NightVisionCommand;
import net.thenextlvl.utilities.commands.NoClipCommand;
import net.thenextlvl.utilities.commands.PotteryCommand;
import net.thenextlvl.utilities.commands.UtilsCommand;
import net.thenextlvl.utilities.commands.aliases.ConvexSelectionAlias;
import net.thenextlvl.utilities.commands.aliases.CuboidSelectionAlias;
import net.thenextlvl.utilities.commands.aliases.DeformRotateAlias;
import net.thenextlvl.utilities.commands.aliases.ScaleAlias;
import net.thenextlvl.utilities.commands.aliases.TwistAlias;
import net.thenextlvl.utilities.listeners.AdvancedFlyListener;
import net.thenextlvl.utilities.listeners.AirPlacingListener;
import net.thenextlvl.utilities.listeners.BlockBreakListener;
import net.thenextlvl.utilities.listeners.BlockPhysicsListener;
import net.thenextlvl.utilities.listeners.ConnectionListener;
import net.thenextlvl.utilities.listeners.OpenableListener;
import net.thenextlvl.utilities.listeners.PlayerInteractListener;
import net.thenextlvl.utilities.listeners.SlimeListener;
import net.thenextlvl.utilities.listeners.TeleportListener;
import net.thenextlvl.utilities.listeners.WorldListener;
import net.thenextlvl.utilities.metrics.bukkit.Metrics;
import net.thenextlvl.utilities.utils.Commands;
import net.thenextlvl.utilities.utils.NoClipManager;
import net.thenextlvl.utilities.utils.PluginConfig;
import net.thenextlvl.utilities.version.PluginVersionChecker;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class UtilitiesPlugin
extends JavaPlugin {
    public static final ErrorTracker ERROR_TRACKER = ErrorTracker.contextAware();
    private final Key key = Key.key((String)"utilities", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("messages.properties", Locale.US).resource("messages_german.properties", Locale.GERMANY).build();
    private final PluginConfig config = (PluginConfig)new GsonFile<PluginConfig>(this.getDataPath().resolve("config.json"), new PluginConfig(true, true, false, true, true, true, true, true, true, false, true)).validate().save(new FileAttribute[0]).getRoot();
    private final Commands commands = (Commands)new GsonFile<Commands>(this.getDataPath().resolve("commands.json"), new Commands()).validate().save(new FileAttribute[0]).getRoot();
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final BukkitMetrics fastStats = ((BukkitMetrics.Factory)((BukkitMetrics.Factory)BukkitMetrics.factory().token("524c53930762784671a459e9f3b45aa4")).errorTracker(ERROR_TRACKER)).create((Plugin)this);
    private final Metrics metrics = new Metrics((Plugin)this, 22858);

    public void onLoad() {
        this.versionChecker.checkVersion();
    }

    public void onEnable() {
        this.fastStats.ready();
        NoClipManager.start(this);
        this.registerListeners();
        this.registerCommands();
    }

    public void onDisable() {
        this.fastStats.shutdown();
        this.metrics.shutdown();
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new AdvancedFlyListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AirPlacingListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPhysicsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OpenableListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SlimeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TeleportListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> {
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(AdvancedFlyCommand.create(this), this.commands.advancedFly.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(AirPlaceCommand.create(this), this.commands.airPlace.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(BannerCommand.create(this), this.commands.banner.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(ColorCommand.create(this), this.commands.color.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(NightVisionCommand.create(this), this.commands.nightVision.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(NoClipCommand.create(this), this.commands.noClip.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(PotteryCommand.create(this), this.commands.pottery.aliases());
            ((io.papermc.paper.command.brigadier.Commands)event.registrar()).register(UtilsCommand.create(this), this.commands.utils.aliases());
            this.registerAliases((io.papermc.paper.command.brigadier.Commands)event.registrar());
        }));
    }

    private void registerAliases(io.papermc.paper.command.brigadier.Commands registrar) {
        if (this.getServer().getPluginManager().getPlugin("FastAsyncWorldEdit") == null) {
            return;
        }
        registrar.register(ConvexSelectionAlias.create(this), this.commands.convex.aliases());
        registrar.register(CuboidSelectionAlias.create(this), this.commands.cuboid.aliases());
        registrar.register(DeformRotateAlias.create(this), this.commands.deformRotate.aliases());
        registrar.register(ScaleAlias.create(this), this.commands.scale.aliases());
        registrar.register(TwistAlias.create(this), this.commands.twist.aliases());
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    public PluginConfig config() {
        return this.config;
    }

    public Commands commands() {
        return this.commands;
    }
}

