/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32C;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GsonFile<R> {
    private static final int BUFFER_SIZE = 8192;
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().serializeNulls().create();
    private final Path file;
    private final R defaultRoot;
    private final Type type;
    private R root;
    private boolean loaded;
    private String digest = "";
    private long lastModified = 0L;

    public GsonFile(Path file, R root, TypeToken<R> token) {
        this.defaultRoot = root;
        this.file = file;
        this.root = root;
        this.type = token.getType();
    }

    public R getRoot() {
        if (this.loaded) {
            return this.root;
        }
        this.loaded = true;
        this.root = this.load();
        return this.root;
    }

    private GsonFile<R> setRoot(R root) {
        this.loaded = true;
        this.root = root;
        return this;
    }

    public GsonFile<R> reload() {
        return this.setRoot(this.load());
    }

    public GsonFile<R> saveIfAbsent(FileAttribute<?> ... attributes) {
        return Files.isRegularFile(this.file, new LinkOption[0]) ? this : this.save(attributes);
    }

    private R load() {
        if (!Files.isRegularFile(this.file, new LinkOption[0])) {
            return this.getRoot();
        }
        try {
            Object object;
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(this.file, StandardOpenOption.READ), StandardCharsets.UTF_8));
            try {
                Object root = GSON.fromJson(reader, this.type);
                object = root != null ? root : this.defaultRoot;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return (R)object;
        }
        finally {
            this.digest = this.digest();
            this.lastModified = this.lastModified();
        }
    }

    public GsonFile<R> save(FileAttribute<?> ... attributes) {
        try {
            GsonFile gsonFile;
            R root = this.getRoot();
            Files.createDirectories(this.file.toAbsolutePath().getParent(), attributes);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8));
            try {
                GSON.toJson(root, this.type, (Appendable)writer);
                gsonFile = this;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            writer.close();
            return gsonFile;
        }
        finally {
            this.digest = this.digest();
            this.lastModified = this.lastModified();
        }
    }

    public boolean hasChanged() {
        return this.lastModified() != this.lastModified && !this.digest.equals(this.digest());
    }

    private String digest() {
        try {
            if (!Files.exists(this.file, new LinkOption[0])) {
                return "";
            }
            CRC32C crc = new CRC32C();
            try (InputStream input = Files.newInputStream(this.file, new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    crc.update(buffer, 0, bytesRead);
                }
            }
            return Long.toHexString(crc.getValue());
        }
        catch (IOException e) {
            return "";
        }
    }

    private long lastModified() {
        try {
            if (!Files.exists(this.file, new LinkOption[0])) {
                return System.currentTimeMillis();
            }
            return Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return System.currentTimeMillis();
        }
    }
}

