/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander;

import com.google.gson.reflect.TypeToken;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.commander.CommanderCommons;
import net.thenextlvl.commander.file.GsonFile;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class CommonPermissionOverride
implements net.thenextlvl.commander.PermissionOverride {
    protected final GsonFile<Map<String, String>> overridesFile;
    protected final CommanderCommons commons;

    public CommonPermissionOverride(CommanderCommons commons) {
        this.overridesFile = new GsonFile<Map<String, String>>(commons.getDataPath().resolve("permission-overrides.json"), new HashMap(), new TypeToken<Map<String, String>>(this){}).reload().saveIfAbsent(new FileAttribute[0]);
        this.commons = commons;
    }

    public boolean save(boolean force) {
        if (!force && this.overridesFile.hasChanged()) {
            return false;
        }
        this.overridesFile.save(new FileAttribute[0]);
        return true;
    }

    public boolean reload(Audience audience) {
        GsonFile<Map<String, String>> current;
        Map<String, String> previous = this.overridesFile.getRoot();
        if (previous.equals((current = this.overridesFile.reload()).getRoot())) {
            return false;
        }
        Map<PermissionOverride, Boolean> difference = this.difference(previous, current.getRoot());
        long additions = difference.entrySet().stream().filter(Map.Entry::getValue).count();
        this.commons.bundle().sendMessage(audience, "command.reload.changes", new TagResolver[]{Formatter.number((String)"additions", (Number)additions), Formatter.number((String)"deletions", (Number)((long)difference.size() - additions)), Placeholder.parsed((String)"file", (String)"permission-overrides.json")});
        difference.forEach((command, added) -> {
            if (added.booleanValue()) {
                this.override(command.command(), command.permission());
            } else {
                this.reset(command.command());
            }
        });
        return true;
    }

    @Override
    public @Unmodifiable Map<String, String> overrides() {
        return Map.copyOf(this.overridesFile.getRoot());
    }

    @Override
    public @Nullable String permission(String command) {
        return this.overridesFile.getRoot().get(command);
    }

    @Override
    public boolean isOverridden(String command) {
        return this.overridesFile.getRoot().containsKey(command);
    }

    @Override
    public boolean override(String command, String permission) {
        Stream<String> commands = this.commons.commandFinder().findCommands(command);
        if (!Stream.concat(commands, Stream.of(command)).filter(s -> this.internalOverride((String)s, permission)).map(s -> this.overridesFile.getRoot().put((String)s, permission) == null).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        this.commons.updateCommands();
        return true;
    }

    @Override
    public boolean reset(String command) {
        Stream<String> commands = this.commons.commandFinder().findCommands(this.overridesFile.getRoot().keySet().stream(), command);
        List<String> reset = Stream.concat(commands, Stream.of(command)).toList();
        if (!reset.stream().map(s -> this.overridesFile.getRoot().remove(s) != null).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        if (!reset.stream().map(this::internalReset).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        this.commons.updateCommands();
        return true;
    }

    protected abstract boolean internalOverride(String var1, String var2);

    protected abstract boolean internalReset(String var1);

    protected Map<PermissionOverride, Boolean> difference(Map<String, String> previous, Map<String, String> current) {
        HashMap<PermissionOverride, Boolean> differences = new HashMap<PermissionOverride, Boolean>();
        current.entrySet().stream().filter(entry -> !Objects.equals(previous.get(entry.getKey()), entry.getValue())).forEach(entry -> differences.put(new PermissionOverride((String)entry.getKey(), (String)entry.getValue()), true));
        previous.entrySet().stream().filter(entry -> !current.containsKey(entry.getKey())).forEach(entry -> differences.put(new PermissionOverride((String)entry.getKey(), (String)entry.getValue()), false));
        return differences;
    }

    protected record PermissionOverride(String command, String permission) {
    }
}

