/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander;

import com.google.gson.reflect.TypeToken;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.commander.CommandRegistry;
import net.thenextlvl.commander.CommanderCommons;
import net.thenextlvl.commander.file.GsonFile;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class CommonCommandRegistry
implements CommandRegistry {
    protected final GsonFile<Set<String>> hiddenFile;
    protected final GsonFile<Set<String>> unregisteredFile;
    protected final CommanderCommons commons;

    protected CommonCommandRegistry(CommanderCommons commons) {
        this.hiddenFile = new GsonFile<Set<String>>(commons.getDataPath().resolve("hidden-commands.json"), new HashSet(), new TypeToken<Set<String>>(this){}).reload().saveIfAbsent(new FileAttribute[0]);
        this.unregisteredFile = new GsonFile<Set<String>>(commons.getDataPath().resolve("removed-commands.json"), new HashSet(), new TypeToken<Set<String>>(this){}).reload().saveIfAbsent(new FileAttribute[0]);
        this.commons = commons;
    }

    @Override
    public @Unmodifiable Set<String> hiddenCommands() {
        return Set.copyOf((Collection)this.hiddenFile.getRoot());
    }

    @Override
    public @Unmodifiable Set<String> unregisteredCommands() {
        return Set.copyOf((Collection)this.unregisteredFile.getRoot());
    }

    @Override
    public boolean hide(String command) {
        Stream<String> commands = this.commons.commandFinder().findCommands(command);
        if (!Stream.concat(commands, Stream.of(command)).map(this.hiddenFile.getRoot()::add).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        this.commons.updateCommands();
        return true;
    }

    @Override
    public boolean isHidden(String command) {
        return this.hiddenFile.getRoot().contains(command);
    }

    @Override
    public boolean isUnregistered(String command) {
        return this.unregisteredFile.getRoot().contains(command);
    }

    @Override
    public boolean register(String command) {
        if (!this.commons.commandFinder().findCommands(Set.copyOf((Collection)this.unregisteredFile.getRoot()).stream(), command).filter(this.unregisteredFile.getRoot()::remove).map(this::internalRegister).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        this.commons.updateCommands();
        return true;
    }

    @Override
    public boolean reveal(String command) {
        if (!this.commons.commandFinder().findCommands(Set.copyOf((Collection)this.hiddenFile.getRoot()).stream(), command).map(this.hiddenFile.getRoot()::remove).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        this.commons.updateCommands();
        return true;
    }

    @Override
    public void unregisterCommands() {
        this.unregisteredCommands().stream().filter(command -> !command.equals(this.commons.getRootCommand())).forEach(this::internalUnregister);
    }

    @Override
    public boolean unregister(String command) {
        if (!this.commons.commandFinder().findCommands(command).filter(s -> !s.equals(this.commons.getRootCommand())).filter(this.unregisteredFile.getRoot()::add).map(this::internalUnregister).reduce(false, Boolean::logicalOr).booleanValue()) {
            return false;
        }
        this.commons.updateCommands();
        return true;
    }

    public boolean save(boolean force) {
        return this.saveHidden(force) & this.saveUnregistered(force);
    }

    public boolean saveHidden(boolean force) {
        if (!force && this.hiddenFile.hasChanged()) {
            return false;
        }
        this.hiddenFile.save(new FileAttribute[0]);
        return true;
    }

    public boolean saveUnregistered(boolean force) {
        if (!force && this.unregisteredFile.hasChanged()) {
            return false;
        }
        this.unregisteredFile.save(new FileAttribute[0]);
        return true;
    }

    public boolean reload(Audience audience) {
        return this.reloadHidden(audience) | this.reloadUnregistered(audience);
    }

    private boolean reloadHidden(Audience audience) {
        GsonFile<Set<String>> current;
        Set<String> previous = this.hiddenFile.getRoot();
        if (previous.equals((current = this.hiddenFile.reload()).getRoot())) {
            return false;
        }
        Map<String, Boolean> difference = this.difference(previous, current.getRoot());
        long additions = difference.entrySet().stream().filter(Map.Entry::getValue).count();
        this.commons.bundle().sendMessage(audience, "command.reload.changes", new TagResolver[]{Formatter.number((String)"additions", (Number)additions), Formatter.number((String)"deletions", (Number)((long)difference.size() - additions)), Placeholder.parsed((String)"file", (String)"hidden-commands.json")});
        this.commons.updateCommands();
        return true;
    }

    private boolean reloadUnregistered(Audience audience) {
        GsonFile<Set<String>> current;
        Set<String> previous = this.unregisteredFile.getRoot();
        if (previous.equals((current = this.unregisteredFile.reload()).getRoot())) {
            return false;
        }
        Map<String, Boolean> difference = this.difference(previous, current.getRoot());
        long additions = difference.entrySet().stream().filter(Map.Entry::getValue).count();
        difference.forEach((command, added) -> {
            if (added.booleanValue()) {
                this.internalUnregister((String)command);
            } else {
                this.internalRegister((String)command);
            }
        });
        this.commons.bundle().sendMessage(audience, "command.reload.changes", new TagResolver[]{Formatter.number((String)"additions", (Number)additions), Formatter.number((String)"deletions", (Number)((long)difference.size() - additions)), Placeholder.parsed((String)"file", (String)"unregistered-commands.json")});
        this.commons.updateCommands();
        return true;
    }

    protected abstract boolean internalRegister(String var1);

    protected abstract boolean internalUnregister(String var1);

    private Map<String, Boolean> difference(Set<String> previous, Set<String> current) {
        HashMap<String, Boolean> differences = new HashMap<String, Boolean>();
        differences.putAll(current.stream().filter(s -> !previous.contains(s)).collect(Collectors.toMap(s -> s, s -> true)));
        differences.putAll(previous.stream().filter(s -> !current.contains(s)).collect(Collectors.toMap(s -> s, s -> false)));
        return differences;
    }
}

