/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.thenextlvl.commander.CommandFinder;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class CommonCommandFinder
implements CommandFinder {
    @Override
    public @Unmodifiable Stream<String> findCommands(Stream<String> commands, Pattern pattern) {
        return commands.filter(command -> pattern.matcher((CharSequence)command).matches());
    }

    @Override
    public @Unmodifiable Stream<String> findCommands(Stream<String> commands, String input) {
        try {
            return this.findCommands(commands, Pattern.compile(input.replace("*", ".*")));
        }
        catch (PatternSyntaxException e) {
            String escaped = Pattern.quote(input).replace("\\*", "*");
            return this.findCommands(commands, Pattern.compile(escaped.replace("*", ".*")));
        }
    }

    @Override
    public @Unmodifiable Stream<String> findCommands(String input) {
        try {
            return this.findCommands(Pattern.compile(input.replace("*", ".*")));
        }
        catch (PatternSyntaxException e) {
            String escaped = Pattern.quote(input).replace("\\*", "*");
            return this.findCommands(Pattern.compile(escaped.replace("*", ".*")));
        }
    }
}

