/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander;

import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.commander.CommandFinder;
import net.thenextlvl.commander.CommonCommandRegistry;
import net.thenextlvl.commander.CommonPermissionOverride;
import net.thenextlvl.commander.access.BrigadierAccess;
import net.thenextlvl.i18n.ComponentBundle;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;

@NullMarked
public abstract class CommanderCommons {
    private final Path dataPath;
    private final ComponentBundle bundle;

    protected CommanderCommons(Path dataPath) {
        this.dataPath = dataPath;
        Key key = Key.key((String)"commander", (String)"translations");
        Path translations = dataPath.resolve("translations");
        this.bundle = ComponentBundle.builder(key, translations).placeholder("prefix", "prefix").miniMessage(MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholder.parsed((String)"root_command", (String)this.getRootCommand())})).build()).resource("commander.properties", Locale.US).resource("commander_german.properties", Locale.GERMANY).build();
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public abstract CommandFinder commandFinder();

    public abstract CommonCommandRegistry commandRegistry();

    public abstract CommonPermissionOverride permissionOverride();

    public abstract Logger logger();

    public abstract <S> BrigadierAccess<S> brigadierAccess();

    public abstract String getRootCommand();

    public abstract Stream<String> getKnownCommands();

    public abstract Stream<String> getKnownPermissions();

    public abstract void updateCommands();

    public final void conflictSave(Audience audience) {
        if (this.commandRegistry().save(false) & this.permissionOverride().save(false)) {
            return;
        }
        this.bundle().sendMessage(audience, "command.save.conflict");
    }

    public final void hiddenConflictSave(Audience audience) {
        if (this.commandRegistry().saveHidden(false)) {
            return;
        }
        this.bundle().sendMessage(audience, "command.save.conflict");
    }

    public final void unregisteredConflictSave(Audience audience) {
        if (this.commandRegistry().saveUnregistered(false)) {
            return;
        }
        this.bundle().sendMessage(audience, "command.save.conflict");
    }

    public final void permissionConflictSave(Audience audience) {
        if (this.permissionOverride().save(false)) {
            return;
        }
        this.bundle().sendMessage(audience, "command.save.conflict");
    }
}

