/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander.util;

import core.file.FileIO;
import core.io.PathIO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.CRC32C;

public final class FileUtil {
    private static final int BUFFER_SIZE = 8192;

    public static String digest(FileIO<?> file) {
        return FileUtil.digest(((PathIO)file.getIO()).getPath());
    }

    public static String digest(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return "";
            }
            CRC32C crc = new CRC32C();
            try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    crc.update(buffer, 0, bytesRead);
                }
            }
            return Long.toHexString(crc.getValue());
        }
        catch (IOException e) {
            return "";
        }
    }

    public static long lastModified(FileIO<?> file) {
        try {
            Path path = ((PathIO)file.getIO()).getPath();
            if (!Files.exists(path, new LinkOption[0])) {
                return System.currentTimeMillis();
            }
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return System.currentTimeMillis();
        }
    }

    public static boolean hasChanged(FileIO<?> file, String digest, long lastModified) {
        return FileUtil.lastModified(file) != lastModified && !FileUtil.digest(file).equals(digest);
    }
}

