/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander.paper.implementation;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thenextlvl.commander.CommonPermissionOverride;
import net.thenextlvl.commander.paper.CommanderPlugin;
import net.thenextlvl.commander.paper.PaperCommander;
import org.bukkit.command.Command;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperPermissionOverride
extends CommonPermissionOverride {
    private final Map<String, @Nullable String> originalPermissions = new HashMap<String, String>();

    public PaperPermissionOverride(PaperCommander commander) {
        super(commander);
    }

    @Override
    public @Unmodifiable Map<String, @Nullable String> originalPermissions() {
        return Map.copyOf(this.originalPermissions);
    }

    @Override
    public @Nullable String originalPermission(String command) {
        return this.originalPermissions.get(command);
    }

    @Override
    public void overridePermissions() {
        ((Map)this.overridesFile.getRoot()).forEach(this::internalOverride);
    }

    @Override
    protected boolean internalOverride(String command, String permission) {
        CommandNode child;
        String registeredPermission;
        CommanderPlugin plugin = ((PaperCommander)this.commons).getPlugin();
        Command registered = (Command)plugin.getServer().getCommandMap().getKnownCommands().get(command);
        String string = registeredPermission = registered != null ? registered.getPermission() : null;
        if (permission.equals(registeredPermission)) {
            return false;
        }
        this.originalPermissions.putIfAbsent(command, registeredPermission);
        CommandDispatcher<CommandSourceStack> dispatcher = plugin.commandDispatcher();
        CommandNode commandNode = child = dispatcher != null ? dispatcher.getRoot().getChild(command) : null;
        if (child != null) {
            return true;
        }
        if (registered == null) {
            return false;
        }
        registered.setPermission(permission);
        return Objects.equals(registered.getPermission(), permission);
    }

    @Override
    protected boolean internalReset(String command) {
        CommandNode child;
        CommanderPlugin plugin = ((PaperCommander)this.commons).getPlugin();
        Command registered = (Command)plugin.getServer().getCommandMap().getKnownCommands().get(command);
        if (!this.originalPermissions.containsKey(command)) {
            return false;
        }
        String permission = this.originalPermissions.remove(command);
        CommandDispatcher<CommandSourceStack> dispatcher = plugin.commandDispatcher();
        CommandNode commandNode = child = dispatcher != null ? dispatcher.getRoot().getChild(command) : null;
        if (child != null) {
            return true;
        }
        if (registered == null) {
            return false;
        }
        if (Objects.equals(registered.getPermission(), permission)) {
            return false;
        }
        registered.setPermission(permission);
        return Objects.equals(registered.getPermission(), permission);
    }
}

