/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.binder;

import java.util.Optional;
import net.thenextlvl.binder.SimpleStaticBinder;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;

public sealed interface StaticBinder
permits SimpleStaticBinder {
    @CheckReturnValue
    public static StaticBinder getInstance() {
        return StaticBinder.getInstance(Thread.currentThread().getContextClassLoader());
    }

    @CheckReturnValue
    public static StaticBinder getInstance(ClassLoader loader) {
        return SimpleStaticBinder.getInstance(loader);
    }

    @Contract(mutates="this")
    public <T> void bind(Class<T> var1, T var2) throws IllegalArgumentException, SecurityException;

    @CheckReturnValue
    @Contract(mutates="this")
    public <T> Optional<T> get(Class<T> var1) throws SecurityException;

    public <T> T find(Class<T> var1) throws IllegalStateException, SecurityException;
}

