/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.tag;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.argument.ColorArgumentType;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import org.bukkit.Color;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterTagBackgroundColorCommand
extends SimpleCommand {
    private CharacterTagBackgroundColorCommand(CharacterPlugin plugin) {
        super(plugin, "background-color", null);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> set(CharacterPlugin plugin) {
        CharacterTagBackgroundColorCommand command = new CharacterTagBackgroundColorCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(Commands.argument((String)"color", (ArgumentType)new ColorArgumentType()).executes((Command)command));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> reset(CharacterPlugin plugin) {
        CharacterTagBackgroundColorCommand command = new CharacterTagBackgroundColorCommand(plugin);
        return (LiteralArgumentBuilder)command.create().executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Character character = (Character)context.getArgument("character", Character.class);
        Color color = this.tryGetArgument(context, "color", Color.class).orElse(null);
        boolean success = character.getTagOptions().setBackgroundColor(color);
        String message = success ? "character.tag.background-color" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"value", (String)(color != null ? "#" + Integer.toHexString(color.asARGB()) : "null"))});
        return success ? 1 : 0;
    }
}

