/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterCreateCommand
extends SimpleCommand {
    private CharacterCreateCommand(CharacterPlugin plugin) {
        super(plugin, "create", "characters.command.create");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterCreateCommand command = new CharacterCreateCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)CharacterCommand.nameArgument(plugin).then(CharacterCreateCommand.typeArgument(plugin).executes((Command)command))).executes((Command)command));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, EntityType> typeArgument(CharacterPlugin plugin) {
        return Commands.argument((String)"type", (ArgumentType)ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String name = (String)context.getArgument("name", String.class);
        if (this.plugin.characterController().characterExists(name)) {
            this.plugin.bundle().sendMessage((Audience)sender, "character.exists", new TagResolver[]{Placeholder.unparsed((String)"name", (String)name)});
            return 0;
        }
        EntityType type = this.tryGetArgument(context, "type", EntityType.class).orElse(EntityType.MANNEQUIN);
        this.plugin.characterController().spawnCharacter(name, ((CommandSourceStack)context.getSource()).getLocation(), type);
        this.plugin.bundle().sendMessage((Audience)sender, "character.created", new TagResolver[]{Placeholder.unparsed((String)"name", (String)name), Placeholder.unparsed((String)"type", (String)type.key().asString())});
        return 1;
    }
}

