/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.character;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.CharacterController;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.character.PaperCharacter;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperCharacterController
implements CharacterController {
    private final CharacterPlugin plugin;
    public final Map<String, Character<?>> characters = new HashMap();

    public PaperCharacterController(CharacterPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public <T extends Entity> Character<T> createCharacter(String name, Class<T> type) {
        return this.createCharacter(name, this.getEntityTypeByClass(type));
    }

    @Override
    public <T extends Entity> Character<T> createCharacter(String name, EntityType type) {
        Preconditions.checkArgument((!this.characterExists(name) ? 1 : 0) != 0, (String)"Character named %s already exists", (Object)name);
        PaperCharacter character = new PaperCharacter(this.plugin, name, type);
        this.characters.put(name, character);
        return character;
    }

    @Override
    public <T extends Entity> Character<T> spawnCharacter(String name, Location location, Class<T> type) {
        return this.spawnCharacter(name, location, this.getEntityTypeByClass(type));
    }

    @Override
    public <T extends Entity> Character<T> spawnCharacter(String name, Location location, EntityType type) {
        Character<T> character = this.createCharacter(name, type);
        character.spawn(location);
        return character;
    }

    @Override
    public Character<Mannequin> createCharacter(String name) {
        return this.createCharacter(name, EntityType.MANNEQUIN);
    }

    @Override
    public Character<Mannequin> spawnCharacter(String name, Location location) {
        return this.spawnCharacter(name, location, EntityType.MANNEQUIN);
    }

    @Override
    public <T extends Entity> Optional<Character<T>> getCharacter(T entity) {
        return this.getCharacters().filter(character -> character.getEntity().filter(arg_0 -> ((Entity)entity).equals(arg_0)).isPresent()).map(character -> character).findAny();
    }

    @Override
    public Optional<Character<?>> getCharacter(String name) {
        return Optional.ofNullable(this.characters.get(name));
    }

    @Override
    public Optional<Character<?>> getCharacter(UUID uuid) {
        return this.getCharacters().filter(character -> character.getEntity().map(Entity::getUniqueId).filter(uuid::equals).isPresent()).findAny();
    }

    @Override
    public Stream<Character<?>> getCharacters() {
        return this.characters.values().stream();
    }

    @Override
    public Stream<Character<?>> getCharacters(Chunk chunk) {
        return this.getCharacters().filter(character -> character.getLocation().or(character::getSpawnLocation).filter(location -> {
            if (!chunk.getWorld().equals((Object)location.getWorld())) {
                return false;
            }
            int chunkX = location.getBlockX() >> 4;
            int chunkZ = location.getBlockZ() >> 4;
            return chunkX == chunk.getX() && chunkZ == chunk.getZ();
        }).isPresent());
    }

    @Override
    public Stream<Character<?>> getCharacters(Player player) {
        return this.getCharacters().filter(character -> character.canSee(player));
    }

    @Override
    public Stream<Character<?>> getCharacters(World world) {
        return this.getCharacters().filter(character -> character.getWorld().map(arg_0 -> ((World)world).equals(arg_0)).orElse(false));
    }

    @Override
    public Stream<Character<?>> getCharactersNearby(Location location, double radius) {
        Preconditions.checkArgument((radius > 0.0 ? 1 : 0) != 0, (Object)"Radius must be greater than 0");
        Preconditions.checkNotNull((Object)location.getWorld(), (Object)"World cannot be null");
        double radiusSquared = radius * radius;
        return this.getCharacters(location.getWorld()).filter(character -> character.getLocation().map(location1 -> location1.distanceSquared(location) <= radiusSquared).orElse(false));
    }

    @Override
    public @Unmodifiable Set<String> getCharacterNames() {
        return Set.copyOf(this.characters.keySet());
    }

    @Override
    public boolean characterExists(String name) {
        return this.characters.containsKey(name);
    }

    @Override
    public boolean isCharacter(Entity entity) {
        return this.getCharacters().anyMatch(character -> character.getEntity().map(arg_0 -> ((Entity)entity).equals(arg_0)).orElse(false));
    }

    public void unregister(String name) {
        this.characters.remove(name);
    }

    private EntityType getEntityTypeByClass(Class<? extends Entity> type) {
        return Arrays.stream(EntityType.values()).filter(entityType -> type.equals(entityType.getEntityClass())).findAny().orElseThrow();
    }
}

