/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.action;

import java.time.Duration;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.thenextlvl.character.action.ActionType;
import net.thenextlvl.character.action.ClickType;
import net.thenextlvl.character.action.SimpleClickAction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed interface ClickAction<T>
permits SimpleClickAction {
    @Contract(pure=true)
    public ActionType<T> getActionType();

    @Contract(pure=true)
    public EnumSet<ClickType> getClickTypes();

    @Contract(mutates="this")
    public boolean setClickTypes(EnumSet<ClickType> var1);

    @Contract(pure=true)
    public boolean isSupportedClickType(ClickType var1);

    @Contract(pure=true)
    public T getInput();

    @Contract(mutates="this")
    public boolean setInput(T var1);

    @Contract(pure=true)
    public @Range(from=0L, to=100L) int getChance();

    @Contract(mutates="this")
    public boolean setChance(@Range(from=0L, to=100L) int var1);

    @Contract(pure=true)
    public @Nullable String getPermission();

    @Contract(mutates="this")
    public boolean setPermission(@Nullable String var1);

    @Contract(pure=true)
    public Duration getCooldown();

    @Contract(mutates="this")
    public boolean setCooldown(Duration var1);

    @Contract(pure=true)
    public boolean isOnCooldown(Player var1);

    @Contract(mutates="this")
    public boolean resetCooldown(Player var1);

    @Contract(pure=true)
    public boolean canInvoke(Player var1);

    public boolean invoke(Player var1, Entity var2);

    @Contract(value="_, _, _ -> new", pure=true)
    public static <T> ClickAction<T> create(ActionType<T> actionType, EnumSet<ClickType> clickTypes, T input) {
        return new SimpleClickAction<T>(actionType, clickTypes, input);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static <T> ClickAction<T> create(ActionType<T> actionType, EnumSet<ClickType> clickTypes, T input, Consumer<ClickAction<T>> configurator) {
        ClickAction<T> action = ClickAction.create(actionType, clickTypes, input);
        configurator.accept(action);
        return action;
    }
}

