/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.goal.Goal;
import net.thenextlvl.character.tag.TagOptions;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Character<E extends Entity> {
    @Contract(pure=true)
    public Optional<ClickAction<?>> getAction(String var1);

    @Contract(pure=true)
    public @Unmodifiable Map<String, ClickAction<?>> getActions();

    @Contract(pure=true)
    public Optional<Component> getDisplayName();

    @Contract(pure=true)
    public @Unmodifiable Set<Goal> getGoals();

    @Contract(mutates="this")
    public boolean addGoal(Goal var1);

    @Contract(mutates="this")
    public boolean removeGoal(Goal var1);

    @Contract(pure=true)
    public <T> Optional<T> getEntity(Class<T> var1);

    @Contract(pure=true)
    public Optional<E> getEntity();

    @Contract(pure=true)
    public Class<? extends E> getEntityClass();

    @Contract(pure=true)
    public Optional<NamedTextColor> getTeamColor();

    @Contract(pure=true)
    public Optional<Location> getLocation();

    @Contract(pure=true)
    public String getName();

    @Contract(pure=true)
    public Optional<String> getViewPermission();

    @Contract(pure=true)
    public Optional<Location> getSpawnLocation();

    @Contract(pure=true)
    public TagOptions getTagOptions();

    @Contract(pure=true)
    public EntityType getType();

    @Contract(pure=true)
    public @Unmodifiable Set<UUID> getViewers();

    @Contract(pure=true)
    public Optional<World> getWorld();

    @Contract(pure=true)
    public Optional<Pathfinder> getPathfinder();

    @Contract(mutates="this")
    public <T> boolean addAction(String var1, ClickAction<T> var2);

    @Contract(mutates="this")
    public boolean addViewer(UUID var1);

    @Contract(mutates="this")
    public boolean addViewers(Collection<UUID> var1);

    @Contract(pure=true)
    public boolean canSee(Player var1);

    @Contract(pure=true)
    public boolean hasAction(ClickAction<?> var1);

    @Contract(pure=true)
    public boolean hasAction(String var1);

    @Contract(pure=true)
    public boolean isDisplayNameVisible();

    @Contract(pure=true)
    public boolean isPersistent();

    @Contract(pure=true)
    public boolean isSpawned();

    @Contract(pure=true)
    public boolean isTrackedBy(Player var1);

    @Contract(pure=true)
    public boolean isViewer(UUID var1);

    @Contract(pure=true)
    public boolean isVisibleByDefault();

    @Contract(mutates="io,this")
    public boolean persist();

    @Contract(mutates="this")
    public boolean removeAction(String var1);

    @Contract(mutates="this")
    public boolean removeViewer(UUID var1);

    @Contract(mutates="this")
    public boolean removeViewers(Collection<UUID> var1);

    @Contract(mutates="this")
    public boolean setDisplayName(@Nullable Component var1);

    @Contract(mutates="this")
    public boolean setDisplayNameVisible(boolean var1);

    @Contract(mutates="this")
    public boolean setPersistent(boolean var1);

    @Contract(mutates="this")
    public boolean setSpawnLocation(@Nullable Location var1);

    @Contract(mutates="this")
    public boolean setTeamColor(@Nullable NamedTextColor var1);

    @Contract(mutates="this")
    public boolean setViewPermission(@Nullable String var1);

    @Contract(mutates="this")
    public boolean setVisibleByDefault(boolean var1);

    @Contract(mutates="this")
    public @Nullable E spawn() throws IllegalStateException;

    @Contract(mutates="this")
    public E spawn(Location var1) throws IllegalStateException;

    @Contract(mutates="this")
    public @Nullable E respawn() throws IllegalStateException;

    @Contract(mutates="this")
    public E respawn(Location var1) throws IllegalStateException;

    @Contract(mutates="this")
    public void delete();

    @Contract(mutates="this")
    public void remove();
}

