/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.skin;

import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import core.paper.brigadier.arguments.EnumArgumentType;
import core.paper.brigadier.arguments.codecs.EnumStringCodec;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.BrigadierCommand;
import net.thenextlvl.character.plugin.model.SkinLayer;
import org.bukkit.entity.Mannequin;
import org.jspecify.annotations.NullMarked;

@NullMarked
class CharacterSkinLayerCommand
extends BrigadierCommand {
    private CharacterSkinLayerCommand(CharacterPlugin plugin) {
        super(plugin, "layer", "characters.command.skin.layer");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterSkinLayerCommand command = new CharacterSkinLayerCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(command.layer("hide", false))).then(command.layer("show", true));
    }

    private LiteralArgumentBuilder<CommandSourceStack> layer(String name, boolean visible) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(this.layerArgument().then(CharacterCommand.mannequinCharacterArgument(this.plugin).executes(context -> this.toggle((CommandContext<CommandSourceStack>)context, visible))));
    }

    private ArgumentBuilder<CommandSourceStack, ?> layerArgument() {
        return Commands.argument((String)"layer", EnumArgumentType.of(SkinLayer.class, EnumStringCodec.lowerHyphen()));
    }

    private int toggle(CommandContext<CommandSourceStack> context, boolean visible) {
        Character character = (Character)context.getArgument("character", Character.class);
        SkinLayer layer = (SkinLayer)((Object)context.getArgument("layer", SkinLayer.class));
        int raw = character.getEntity().map(Mannequin::getSkinParts).orElseGet(SkinParts::allParts).getRaw();
        PaperSkinParts skinParts = new PaperSkinParts(visible ? raw | layer.getMask() : raw & ~layer.getMask());
        Boolean success = character.getEntity().map(mannequin -> {
            if (mannequin.getSkinParts().getRaw() == skinParts.getRaw()) {
                return false;
            }
            mannequin.setSkinParts((SkinParts)skinParts);
            return true;
        }).orElse(false);
        String message = success == false ? "nothing.changed" : (visible ? "character.skin_layer.shown" : "character.skin_layer.hidden");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.component((String)"layer", (ComponentLike)Component.translatable((Translatable)layer)), Placeholder.unparsed((String)"character", (String)character.getName())});
        return 1;
    }
}

