/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.action;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.thenextlvl.character.action.ActionType;
import net.thenextlvl.character.action.ActionTypeRegistry;
import net.thenextlvl.character.action.ActionTypes;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class SimpleActionTypeRegistry
implements ActionTypeRegistry {
    public static final ActionTypeRegistry INSTANCE = new SimpleActionTypeRegistry();
    private final Set<ActionType<?>> actionTypes = new HashSet<ActionType<String>>(Set.of(ActionTypes.types().sendActionbar(), ActionTypes.types().sendMessage(), ActionTypes.types().sendEntityEffect(), ActionTypes.types().transfer(), ActionTypes.types().teleport(), ActionTypes.types().playSound(), ActionTypes.types().runConsoleCommand(), ActionTypes.types().runCommand(), ActionTypes.types().sendTitle(), ActionTypes.types().connect()));

    SimpleActionTypeRegistry() {
    }

    @Override
    public boolean register(ActionType<?> type) {
        return !this.isRegistered(type.name()) && this.actionTypes.add(type);
    }

    @Override
    public boolean isRegistered(ActionType<?> type) {
        return this.actionTypes.contains(type);
    }

    @Override
    public boolean isRegistered(String name) {
        return this.actionTypes.stream().anyMatch(actionType -> actionType.name().equals(name));
    }

    @Override
    public boolean unregister(ActionType<?> type) {
        return this.actionTypes.remove(type);
    }

    @Override
    public <T> Optional<ActionType<T>> getByName(String name) {
        return this.actionTypes.stream().filter(actionType -> actionType.name().equals(name)).map(actionType -> actionType).findAny();
    }

    @Override
    public @Unmodifiable Set<ActionType<?>> getActionTypes() {
        return Set.copyOf(this.actionTypes);
    }
}

