/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.action;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import net.kyori.adventure.key.KeyPattern;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.action.ActionType;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class SimpleActionType<T>
implements ActionType<T> {
    @KeyPattern.Value
    private final String name;
    private final Class<T> type;
    private final ActionType.Action<T> action;
    private final @Nullable BiPredicate<T, Character<?>> applicable;

    SimpleActionType(@KeyPattern.Value String name, Class<T> type, ActionType.Action<T> action, @Nullable BiPredicate<T, Character<?>> applicable) {
        this.name = name;
        this.type = type;
        this.action = action;
        this.applicable = applicable;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    @KeyPattern.Value
    public String name() {
        return this.name;
    }

    @Override
    public ActionType.Action<T> action() {
        return this.action;
    }

    @Override
    public boolean isApplicable(T input, Character<?> character) {
        return this.applicable == null || this.applicable.test(input, character);
    }

    public static final class Builder<T>
    implements ActionType.Builder<T> {
        private final Class<T> type;
        @KeyPattern.Value
        private final String name;
        private @Nullable ActionType.Action<T> action;
        private @Nullable BiPredicate<T, Character<?>> applicable = null;

        Builder(Class<T> type, @KeyPattern.Value String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public Builder<T> action(@Nullable ActionType.Action<T> action) {
            this.action = action;
            return this;
        }

        @Override
        public Builder<T> applicable(BiPredicate<T, Character<?>> applicable) {
            this.applicable = applicable;
            return this;
        }

        @Override
        public ActionType<T> build() throws IllegalArgumentException {
            Preconditions.checkArgument((this.action != null ? 1 : 0) != 0, (Object)"action is null");
            return new SimpleActionType<T>(this.name, this.type, this.action, this.applicable);
        }
    }
}

