/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.action;

import java.util.function.BiPredicate;
import net.kyori.adventure.key.KeyPattern;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.action.SimpleActionType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface ActionType<T>
permits SimpleActionType {
    @Contract(pure=true)
    public Class<T> type();

    @KeyPattern.Value
    @Contract(pure=true)
    public String name();

    @Contract(pure=true)
    public Action<T> action();

    @Contract(pure=true)
    public boolean isApplicable(T var1, Character<?> var2);

    @Contract(value="_, _ -> new", pure=true)
    public static <T> Builder<T> builder(@KeyPattern.Value String name, Class<T> type) {
        return new SimpleActionType.Builder<T>(type, name);
    }

    public static sealed interface Builder<T>
    permits SimpleActionType.Builder {
        @Contract(mutates="this")
        public Builder<T> action(Action<T> var1);

        @Contract(mutates="this")
        public Builder<T> applicable(BiPredicate<T, Character<?>> var1);

        @Contract(value=" -> new", pure=true)
        public ActionType<T> build() throws IllegalArgumentException;
    }

    @FunctionalInterface
    public static interface Action<T> {
        public void invoke(Player var1, Entity var2, T var3);
    }
}

