/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.thenextlvl.character.Character;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface CharacterController {
    @Contract(mutates="this")
    public <T extends Entity> Character<T> createCharacter(String var1, Class<T> var2);

    @Contract(mutates="this")
    public <T extends Entity> Character<T> createCharacter(String var1, EntityType var2);

    @Contract(mutates="this")
    public <T extends Entity> Character<T> spawnCharacter(String var1, Location var2, Class<T> var3);

    @Contract(mutates="this")
    public <T extends Entity> Character<T> spawnCharacter(String var1, Location var2, EntityType var3);

    @Contract(mutates="this")
    public Character<Mannequin> createCharacter(String var1);

    @Contract(mutates="this")
    public Character<Mannequin> spawnCharacter(String var1, Location var2);

    public <T extends Entity> Optional<Character<T>> getCharacter(T var1);

    public Optional<Character<?>> getCharacter(String var1);

    public Optional<Character<?>> getCharacter(UUID var1);

    public Stream<Character<?>> getCharacters();

    public Stream<Character<?>> getCharacters(Chunk var1);

    public Stream<Character<?>> getCharacters(Player var1);

    public Stream<Character<?>> getCharacters(World var1);

    public Stream<Character<?>> getCharactersNearby(Location var1, double var2);

    public @Unmodifiable Set<String> getCharacterNames();

    public boolean characterExists(String var1);

    public boolean isCharacter(Entity var1);
}

