/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.serialization;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TitleAdapter
implements TagAdapter<Title> {
    @Override
    public Title deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        Component title = context.deserialize((Tag)root.get("title"), Component.class);
        Component subtitle = context.deserialize((Tag)root.get("subtitle"), Component.class);
        Title.Times times = root.optional("times").map(t -> context.deserialize((Tag)t, Title.Times.class)).orElse(null);
        return Title.title((Component)title, (Component)subtitle, (Title.Times)times);
    }

    @Override
    public Tag serialize(Title title, TagSerializationContext context) throws ParserException {
        CompoundTag.Builder tag = CompoundTag.builder();
        tag.put("title", context.serialize(title.title()));
        tag.put("subtitle", context.serialize(title.subtitle()));
        Optional.ofNullable(title.times()).ifPresent(times -> tag.put("times", context.serialize(times)));
        return tag.build();
    }
}

