/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.serialization;

import com.destroystokyo.paper.profile.ProfileProperty;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.List;
import java.util.UUID;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ResolvableProfileAdapter
implements TagAdapter<ResolvableProfile> {
    @Override
    public ResolvableProfile deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        ResolvableProfile.Builder builder = ResolvableProfile.resolvableProfile();
        root.optional("name").map(Tag::getAsString).ifPresent(arg_0 -> ((ResolvableProfile.Builder)builder).name(arg_0));
        root.optional("uuid").map(id -> context.deserialize((Tag)id, UUID.class)).ifPresent(arg_0 -> ((ResolvableProfile.Builder)builder).uuid(arg_0));
        root.optional("properties").map(Tag::getAsList).map(properties -> properties.stream().map(property -> context.deserialize((Tag)property, ProfileProperty.class)).toList()).ifPresent(arg_0 -> ((ResolvableProfile.Builder)builder).addProperties(arg_0));
        return (ResolvableProfile)builder.build();
    }

    @Override
    public Tag serialize(ResolvableProfile profile, TagSerializationContext context) throws ParserException {
        CompoundTag.Builder tag = CompoundTag.builder();
        if (profile.name() != null) {
            tag.put("name", profile.name());
        }
        if (profile.uuid() != null) {
            tag.put("uuid", context.serialize(profile.uuid()));
        }
        List<Tag> properties = profile.properties().stream().map(context::serialize).toList();
        if (!properties.isEmpty()) {
            tag.put("properties", ListTag.of(properties));
        }
        return tag.build();
    }
}

