/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.serialization;

import net.thenextlvl.character.plugin.model.PaperEntityEquipment;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EntityEquipmentAdapter
implements TagAdapter<PaperEntityEquipment> {
    @Override
    public PaperEntityEquipment deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        ItemStack itemInMainHand = root.optional("itemInMainHand").map(tag1 -> context.deserialize((Tag)tag1, ItemStack.class)).orElse(null);
        ItemStack itemInOffHand = root.optional("itemInOffHand").map(tag1 -> context.deserialize((Tag)tag1, ItemStack.class)).orElse(null);
        ItemStack helmet = root.optional("helmet").map(tag1 -> context.deserialize((Tag)tag1, ItemStack.class)).orElse(null);
        ItemStack chestplate = root.optional("chestplate").map(tag1 -> context.deserialize((Tag)tag1, ItemStack.class)).orElse(null);
        ItemStack leggings = root.optional("leggings").map(tag1 -> context.deserialize((Tag)tag1, ItemStack.class)).orElse(null);
        ItemStack boots = root.optional("boots").map(tag1 -> context.deserialize((Tag)tag1, ItemStack.class)).orElse(null);
        Float itemInMainHandDropChance = root.optional("itemInMainHandDropChance").map(tag1 -> context.deserialize((Tag)tag1, Float.TYPE)).orElse(Float.valueOf(1.0f));
        Float itemInOffHandDropChance = root.optional("itemInOffHandDropChance").map(tag1 -> context.deserialize((Tag)tag1, Float.TYPE)).orElse(Float.valueOf(1.0f));
        Float helmetDropChance = root.optional("helmetDropChance").map(tag1 -> context.deserialize((Tag)tag1, Float.TYPE)).orElse(Float.valueOf(1.0f));
        Float chestplateDropChance = root.optional("chestplateDropChance").map(tag1 -> context.deserialize((Tag)tag1, Float.TYPE)).orElse(Float.valueOf(1.0f));
        Float leggingsDropChance = root.optional("leggingsDropChance").map(tag1 -> context.deserialize((Tag)tag1, Float.TYPE)).orElse(Float.valueOf(1.0f));
        Float bootsDropChance = root.optional("bootsDropChance").map(tag1 -> context.deserialize((Tag)tag1, Float.TYPE)).orElse(Float.valueOf(1.0f));
        return new PaperEntityEquipment(itemInMainHand, itemInOffHand, helmet, chestplate, leggings, boots, itemInMainHandDropChance.floatValue(), itemInOffHandDropChance.floatValue(), helmetDropChance.floatValue(), chestplateDropChance.floatValue(), leggingsDropChance.floatValue(), bootsDropChance.floatValue());
    }

    @Override
    public Tag serialize(PaperEntityEquipment equipment, TagSerializationContext context) throws ParserException {
        CompoundTag.Builder tag = CompoundTag.builder();
        if (equipment.itemInMainHand != null && !equipment.itemInMainHand.isEmpty()) {
            tag.put("itemInMainHand", context.serialize(equipment.itemInMainHand));
        }
        if (equipment.itemInOffHand != null && !equipment.itemInOffHand.isEmpty()) {
            tag.put("itemInOffHand", context.serialize(equipment.itemInOffHand));
        }
        if (equipment.helmet != null && !equipment.helmet.isEmpty()) {
            tag.put("helmet", context.serialize(equipment.helmet));
        }
        if (equipment.chestplate != null && !equipment.chestplate.isEmpty()) {
            tag.put("chestplate", context.serialize(equipment.chestplate));
        }
        if (equipment.leggings != null && !equipment.leggings.isEmpty()) {
            tag.put("leggings", context.serialize(equipment.leggings));
        }
        if (equipment.boots != null && !equipment.boots.isEmpty()) {
            tag.put("boots", context.serialize(equipment.boots));
        }
        tag.put("itemInMainHandDropChance", context.serialize(Float.valueOf(equipment.itemInMainHandDropChance)));
        tag.put("itemInOffHandDropChance", context.serialize(Float.valueOf(equipment.itemInOffHandDropChance)));
        tag.put("helmetDropChance", context.serialize(Float.valueOf(equipment.helmetDropChance)));
        tag.put("chestplateDropChance", context.serialize(Float.valueOf(equipment.chestplateDropChance)));
        tag.put("leggingsDropChance", context.serialize(Float.valueOf(equipment.leggingsDropChance)));
        tag.put("bootsDropChance", context.serialize(Float.valueOf(equipment.bootsDropChance)));
        return tag.build();
    }
}

