/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.tag;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.function.BiFunction;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import net.thenextlvl.character.tag.TagOptions;
import org.joml.Quaternionf;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterTagRotationCommand
extends SimpleCommand {
    private final Rotation rotation;

    private CharacterTagRotationCommand(CharacterPlugin plugin, Rotation rotation) {
        super(plugin, rotation.name, null);
        this.rotation = rotation;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> set(CharacterPlugin plugin, Rotation rotation) {
        CharacterTagRotationCommand command = new CharacterTagRotationCommand(plugin, rotation);
        return (LiteralArgumentBuilder)command.create().then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg()).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"w", (ArgumentType)FloatArgumentType.floatArg()).executes((Command)command))).executes((Command)command))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> reset(CharacterPlugin plugin, Rotation rotation) {
        CharacterTagRotationCommand command = new CharacterTagRotationCommand(plugin, rotation);
        return (LiteralArgumentBuilder)command.create().executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Character character = (Character)context.getArgument("character", Character.class);
        Float w = this.tryGetArgument(context, "w", Float.TYPE).orElse(Float.valueOf(1.0f));
        Float x = this.tryGetArgument(context, "x", Float.TYPE).orElse(Float.valueOf(0.0f));
        Float y = this.tryGetArgument(context, "y", Float.TYPE).orElse(Float.valueOf(0.0f));
        Float z = this.tryGetArgument(context, "z", Float.TYPE).orElse(Float.valueOf(0.0f));
        Boolean success = this.rotation.setter.apply(character.getTagOptions(), new Quaternionf(x.floatValue(), y.floatValue(), z.floatValue(), w.floatValue()));
        String message = success != false ? this.rotation.success : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName()), Formatter.number((String)"w", (Number)w), Formatter.number((String)"x", (Number)x), Formatter.number((String)"y", (Number)y), Formatter.number((String)"z", (Number)z)});
        return success != false ? 1 : 0;
    }

    public static enum Rotation {
        LEFT("left-rotation", "character.tag.left-rotation", TagOptions::setLeftRotation),
        RIGHT("right-rotation", "character.tag.right-rotation", TagOptions::setRightRotation);

        private final String name;
        private final String success;
        private final BiFunction<TagOptions, Quaternionf, Boolean> setter;

        private Rotation(String name, String success, BiFunction<TagOptions, Quaternionf, Boolean> setter) {
            this.name = name;
            this.success = success;
            this.setter = setter;
        }
    }
}

