/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.equipment;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.BrigadierCommand;
import net.thenextlvl.character.plugin.command.equipment.CharacterEquipmentCommand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterEquipmentClearCommand
extends BrigadierCommand {
    private CharacterEquipmentClearCommand(CharacterPlugin plugin) {
        super(plugin, "clear", null);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterEquipmentClearCommand command = new CharacterEquipmentClearCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)CharacterCommand.characterArgument(plugin).then(CharacterEquipmentCommand.equipmentSlotArgument().executes(command::clearSlot))).executes(command::clearEquipment));
    }

    private int clearEquipment(CommandContext<CommandSourceStack> context) {
        Character character = (Character)context.getArgument("character", Character.class);
        Boolean success = character.getEntity(LivingEntity.class).map(LivingEntity::getEquipment).map(equipment -> {
            equipment.clear();
            return true;
        }).orElse(false);
        String message = success != false ? "character.equipment.cleared" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName())});
        return success != false ? 1 : 0;
    }

    private int clearSlot(CommandContext<CommandSourceStack> context) {
        Character character = (Character)context.getArgument("character", Character.class);
        EquipmentSlot slot = (EquipmentSlot)context.getArgument("equipment-slot", EquipmentSlot.class);
        Boolean success = character.getEntity(LivingEntity.class).map(LivingEntity::getEquipment).map(equipment -> {
            equipment.setItem(slot, null, true);
            return true;
        }).orElse(false);
        String message = success != false ? "character.equipment.slot.cleared" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"slot", (String)slot.name().toLowerCase().replace("_", "-"))});
        return success != false ? 1 : 0;
    }
}

