/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.action.ActionCommand;
import net.thenextlvl.character.plugin.command.action.CharacterActionCommand;
import net.thenextlvl.character.plugin.command.suggestion.CharacterWithActionSuggestionProvider;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterActionPermissionCommand
extends ActionCommand {
    private CharacterActionPermissionCommand(CharacterPlugin plugin) {
        super(plugin, "permission", "characters.command.action.permission");
    }

    static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterActionPermissionCommand command = new CharacterActionPermissionCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(CharacterCommand.characterArgument(plugin).suggests(new CharacterWithActionSuggestionProvider(plugin)).then(CharacterActionCommand.actionArgument(plugin).then(Commands.literal((String)"remove").executes(command::set)).then(CharacterCommand.permissionArgument(plugin).executes(command::set)).executes((Command)command)));
    }

    private int set(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Character character = (Character)context.getArgument("character", Character.class);
        String actionName = (String)context.getArgument("action", String.class);
        ClickAction action = character.getAction(actionName).orElse(null);
        String permission = this.tryGetArgument(context, "permission", String.class).orElse(null);
        if (action == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "character.action.not_found", new TagResolver[]{Placeholder.parsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"action", (String)actionName)});
            return 0;
        }
        boolean success = action.setPermission(permission);
        String message = success ? (permission != null ? "character.action.permission.set" : "character.action.permission.removed") : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"action", (String)actionName), Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"permission", (String)String.valueOf(permission))});
        return success ? 1 : 0;
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, Character<?> character, ClickAction<?> action, String actionName) {
        String message = action.getPermission() != null ? "character.action.permission" : "character.action.permission.none";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"permission", (String)String.valueOf(action.getPermission())), Placeholder.unparsed((String)"action", (String)actionName), Placeholder.unparsed((String)"character", (String)character.getName())});
        return 1;
    }
}

