/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.character.goal;

import com.google.common.base.Preconditions;
import java.util.List;
import net.thenextlvl.character.goal.FollowPathGoal;
import net.thenextlvl.character.goal.PathfindOptions;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.character.goal.PaperWalkGoal;
import org.bukkit.Location;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperFollowPathGoal
extends PaperWalkGoal
implements FollowPathGoal {
    private final List<Location> paths;
    private int pathIndex = 0;

    public PaperFollowPathGoal(CharacterPlugin plugin, PathfindOptions options, List<Location> paths) {
        super(plugin, options);
        this.paths = paths;
    }

    @Override
    public void start() {
    }

    @Override
    public @Unmodifiable List<Location> getPaths() {
        return this.paths.stream().map(Location::clone).toList();
    }

    @Override
    public @Nullable Location getCurrentPath() {
        return this.paths.get(this.pathIndex).clone();
    }

    @Override
    public @Nullable Location getGoal() {
        return this.paths.getLast().clone();
    }

    @Override
    public @Nullable Location getNextPath() {
        return this.pathIndex + 1 < this.paths.size() ? this.paths.get(this.pathIndex + 1).clone() : null;
    }

    public static class Builder
    extends PaperWalkGoal.Builder<FollowPathGoal, FollowPathGoal.Builder>
    implements FollowPathGoal.Builder {
        private @Nullable List<Location> paths;

        public Builder(CharacterPlugin plugin) {
            super(plugin);
        }

        @Override
        public FollowPathGoal.Builder paths(List<Location> paths) {
            this.paths = paths;
            return this;
        }

        @Override
        public FollowPathGoal build() {
            Preconditions.checkState((this.paths != null ? 1 : 0) != 0, (Object)"Paths cannot be null");
            Preconditions.checkState((!this.paths.isEmpty() ? 1 : 0) != 0, (Object)"Paths cannot be empty");
            return new PaperFollowPathGoal(this.plugin, this.options.clone(), this.paths.stream().map(Location::clone).toList());
        }

        @Override
        public FollowPathGoal.Builder getSelf() {
            return this;
        }
    }
}

