/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.character.goal;

import com.google.common.base.Preconditions;
import net.thenextlvl.character.goal.AttackGoal;
import net.thenextlvl.character.goal.PathfindOptions;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.character.goal.PaperWalkGoal;
import org.bukkit.entity.Entity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperAttackGoal
extends PaperWalkGoal
implements AttackGoal {
    private final Entity target;
    private final double attackRange;

    public PaperAttackGoal(CharacterPlugin plugin, PathfindOptions options, Entity target, double attackRange) {
        super(plugin, options);
        this.target = target;
        this.attackRange = attackRange;
    }

    @Override
    public Entity getTarget() {
        return this.target;
    }

    @Override
    public double getAttackRange() {
        return this.attackRange;
    }

    @Override
    public void start() {
    }

    public static class Builder
    extends PaperWalkGoal.Builder<AttackGoal, AttackGoal.Builder>
    implements AttackGoal.Builder {
        private @Nullable Entity target;
        private double attackRange = 2.0;

        public Builder(CharacterPlugin plugin) {
            super(plugin);
        }

        @Override
        public AttackGoal.Builder attackRange(double range) {
            this.attackRange = range;
            return this;
        }

        @Override
        public AttackGoal.Builder target(Entity target) {
            this.target = target;
            return this;
        }

        @Override
        public AttackGoal build() {
            Preconditions.checkState((this.target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
            return new PaperAttackGoal(this.plugin, this.options.clone(), this.target, this.attackRange);
        }

        @Override
        public AttackGoal.Builder getSelf() {
            return this;
        }
    }
}

