/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.codec;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.thenextlvl.character.codec.EntityCodec;
import net.thenextlvl.character.codec.EntityCodecRegistry;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class SimpleEntityCodecRegistry
implements EntityCodecRegistry {
    static final SimpleEntityCodecRegistry INSTANCE = new SimpleEntityCodecRegistry();
    private final Set<EntityCodec<?, ?>> codecs = new HashSet();

    SimpleEntityCodecRegistry() {
    }

    @Override
    public void register(EntityCodec<?, ?> codec) throws IllegalStateException {
        Preconditions.checkState((boolean)this.codecs.add(codec), (String)"Codec with the same key is already registered: %s", (Object)codec.key());
    }

    @Override
    public void registerAll(Collection<EntityCodec<?, ?>> codecs) throws IllegalStateException {
        codecs.forEach(this::register);
    }

    @Override
    public boolean unregister(EntityCodec<?, ?> codec) {
        return this.codecs.remove(codec);
    }

    @Override
    public boolean isRegistered(EntityCodec<?, ?> codec) {
        return this.codecs.contains(codec);
    }

    @Override
    public <E, T> Optional<EntityCodec<E, T>> getCodec(Key key) {
        return this.codecs.stream().filter(codec -> codec.key().equals((Object)key)).map(codec -> codec).findAny();
    }

    @Override
    public @Unmodifiable Set<EntityCodec<?, ?>> codecs() {
        return Set.copyOf(this.codecs);
    }
}

