/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.codec;

import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import com.mojang.brigadier.arguments.ArgumentType;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.entity.CollarColorable;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.character.codec.EntityCodec;
import net.thenextlvl.character.codec.EntityCodecRegistry;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.argument.BlockDataArgumentType;
import net.thenextlvl.character.plugin.model.PaperEntityEquipment;
import net.thenextlvl.character.plugin.serialization.AttributeAdapter;
import net.thenextlvl.character.plugin.serialization.BlockDataAdapter;
import net.thenextlvl.character.plugin.serialization.EntityEquipmentAdapter;
import net.thenextlvl.character.plugin.serialization.RegistryAdapter;
import net.thenextlvl.character.plugin.serialization.ResolvableProfileAdapter;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EntityCodecs {
    private static final CharacterPlugin plugin = (CharacterPlugin)JavaPlugin.getPlugin(CharacterPlugin.class);
    private static final EntityCodec<?, ?> SKIN_PARTS = EntityCodec.intCodec(Key.key((String)"mannequin", (String)"skin_parts"), Mannequin.class).getter(mannequin -> mannequin.getSkinParts().getRaw()).setter((mannequin, integer) -> mannequin.setSkinParts((SkinParts)new PaperSkinParts(integer.intValue()))).build();
    private static final EntityCodec<?, ?> RESOLVABLE_PROFILE = EntityCodec.builder(Key.key((String)"mannequin", (String)"profile"), Mannequin.class, ResolvableProfile.class).getter(Mannequin::getProfile).setter(Mannequin::setProfile).adapter(new ResolvableProfileAdapter()).build();
    private static final EntityCodec<?, ?> IMMOVABLE = EntityCodec.booleanCodec(Key.key((String)"mannequin", (String)"immovable"), Mannequin.class).getter(Mannequin::isImmovable).setter(Mannequin::setImmovable).build();
    private static final EntityCodec<?, ?> MAIN_HAND = EntityCodec.enumCodec(Key.key((String)"mannequin", (String)"main_hand"), Mannequin.class, MainHand.class).getter(Mannequin::getMainHand).setter(Mannequin::setMainHand).build();
    private static final EntityCodec<?, ?> BASE_PLATE = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"base_plate"), ArmorStand.class).getter(ArmorStand::hasBasePlate).setter(ArmorStand::setBasePlate).build();
    private static final EntityCodec<?, ?> VISIBLE = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"visible"), ArmorStand.class).getter(ArmorStand::isVisible).setter(ArmorStand::setVisible).build();
    private static final EntityCodec<?, ?> ARMS = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"arms"), ArmorStand.class).getter(ArmorStand::hasArms).setter(ArmorStand::setArms).build();
    private static final EntityCodec<?, ?> SMALL = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"small"), ArmorStand.class).getter(ArmorStand::isSmall).setter(ArmorStand::setSmall).build();
    private static final EntityCodec<?, ?> MARKER = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"marker"), ArmorStand.class).getter(ArmorStand::isMarker).setter(ArmorStand::setMarker).build();
    private static final EntityCodec<?, ?> CAN_MOVE = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"can_move"), ArmorStand.class).getter(ArmorStand::canMove).setter(ArmorStand::setCanMove).build();
    private static final EntityCodec<?, ?> CAN_TICK = EntityCodec.booleanCodec(Key.key((String)"armor_stand", (String)"can_tick"), ArmorStand.class).getter(ArmorStand::canTick).setter(ArmorStand::setCanTick).build();
    private static final EntityCodec<?, ?> AGE = EntityCodec.intCodec(Key.key((String)"ageable", (String)"age"), Ageable.class).getter(Ageable::getAge).setter(Ageable::setAge).build();
    private static final EntityCodec<?, ?> BASE_POTION_TYPE = EntityCodec.enumCodec(Key.key((String)"area_effect_cloud", (String)"base_potion_type"), AreaEffectCloud.class, PotionType.class).getter(AreaEffectCloud::getBasePotionType).setter(AreaEffectCloud::setBasePotionType).build();
    private static final EntityCodec<?, ?> AREA_EFFECT_CLOUD_COLOR = EntityCodec.intCodec(Key.key((String)"area_effect_cloud", (String)"color"), AreaEffectCloud.class).getter(areaEffectCloud -> areaEffectCloud.getColor().asRGB()).setter((areaEffectCloud, integer) -> areaEffectCloud.setColor(integer != null ? Color.fromARGB((int)integer) : null)).build();
    private static final EntityCodec<?, ?> DURATION_ON_USE = EntityCodec.intCodec(Key.key((String)"area_effect_cloud", (String)"duration_on_use"), AreaEffectCloud.class).getter(AreaEffectCloud::getDurationOnUse).setter(AreaEffectCloud::setDurationOnUse).build();
    private static final EntityCodec<?, ?> DURATION = EntityCodec.intCodec(Key.key((String)"area_effect_cloud", (String)"duration"), AreaEffectCloud.class).getter(AreaEffectCloud::getDuration).setter(AreaEffectCloud::setDuration).build();
    private static final EntityCodec<?, ?> PARTICLE = EntityCodec.enumCodec(Key.key((String)"area_effect_cloud", (String)"particle"), AreaEffectCloud.class, Particle.class).getter(AreaEffectCloud::getParticle).setter((areaEffectCloud, particle) -> areaEffectCloud.setParticle(particle)).build();
    private static final EntityCodec<?, ?> RADIUS = EntityCodec.floatCodec(Key.key((String)"area_effect_cloud", (String)"radius"), AreaEffectCloud.class).getter(AreaEffectCloud::getRadius).setter(AreaEffectCloud::setRadius).build();
    private static final EntityCodec<?, ?> REAPPLICATION_DELAY = EntityCodec.intCodec(Key.key((String)"area_effect_cloud", (String)"reapplication_delay"), AreaEffectCloud.class).getter(AreaEffectCloud::getDurationOnUse).setter(AreaEffectCloud::setReapplicationDelay).argumentType((ArgumentType<Integer>)ArgumentTypes.time()).build();
    private static final EntityCodec<?, ?> WAIT_TIME = EntityCodec.intCodec(Key.key((String)"area_effect_cloud", (String)"wait_time"), AreaEffectCloud.class).getter(AreaEffectCloud::getWaitTime).setter(AreaEffectCloud::setWaitTime).argumentType((ArgumentType<Integer>)ArgumentTypes.time()).build();
    private static final EntityCodec<?, ?> ARROW_COLOR = EntityCodec.intCodec(Key.key((String)"arrow", (String)"color"), Arrow.class).getter(arrow -> {
        Color color = arrow.getColor();
        return color != null ? Integer.valueOf(color.asARGB()) : null;
    }).setter((arrow, color) -> arrow.setColor(color != null ? Color.fromARGB((int)color) : null)).build();
    private static final EntityCodec<?, ?> ATTRIBUTES = EntityCodec.builder(Key.key((String)"attributable", (String)"attributes"), Attributable.class, Set.class).getter(attributable -> Registry.ATTRIBUTE.stream().map(arg_0 -> ((Attributable)attributable).getAttribute(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet())).setter((attributable, attributes) -> attributes.forEach(attributeInstance -> {
        AttributeInstance attribute = attributable.getAttribute(attributeInstance.getAttribute());
        if (attribute == null) {
            return;
        }
        attribute.setBaseValue(attributeInstance.getBaseValue());
        attribute.getModifiers().forEach(attributeModifier -> {
            AttributeModifier modifier = attribute.getModifier(attributeModifier.key());
            if (modifier != null) {
                attribute.removeModifier(modifier);
            }
            attribute.addModifier(attributeModifier);
        });
    })).adapter(new AttributeAdapter()).build();
    private static final EntityCodec<?, ?> HEAD_UP = EntityCodec.booleanCodec(Key.key((String)"cat", (String)"head_up"), Cat.class).getter(Cat::isHeadUp).setter(Cat::setHeadUp).build();
    private static final EntityCodec<?, ?> LYING_DOWN = EntityCodec.booleanCodec(Key.key((String)"cat", (String)"lying_down"), Cat.class).getter(Cat::isLyingDown).setter(Cat::setLyingDown).build();
    private static final EntityCodec<?, ?> CAT_VARIANT = EntityCodecs.registryCodec(Key.key((String)"cat", (String)"variant"), Cat.class, Cat.Type.class, RegistryKey.CAT_VARIANT).getter(Cat::getCatType).setter(Cat::setCatType).build();
    private static final EntityCodec<?, ?> DANCING = EntityCodec.booleanCodec(Key.key((String)"allay", (String)"dancing"), Allay.class).getter(Allay::isDancing).setter((allay, dancing) -> {
        if (dancing.booleanValue()) {
            allay.startDancing();
        } else {
            allay.stopDancing();
        }
    }).build();
    private static final EntityCodec<?, ?> CAN_DUPLICATE = EntityCodec.booleanCodec(Key.key((String)"allay", (String)"can_duplicate"), Allay.class).getter(Allay::canDuplicate).setter(Allay::setCanDuplicate).build();
    private static final EntityCodec<?, ?> DUPLICATION_COOLDOWN = EntityCodec.longCodec(Key.key((String)"allay", (String)"duplication_cooldown"), Allay.class).getter(Allay::getDuplicationCooldown).setter(Allay::setDuplicationCooldown).build();
    private static final EntityCodec<?, ?> COLLAR_COLOR = EntityCodec.enumCodec(Key.key((String)"collar_colorable", (String)"collar_color"), CollarColorable.class, DyeColor.class).getter(CollarColorable::getCollarColor).setter(CollarColorable::setCollarColor).build();
    private static final EntityCodec<?, ?> POWERED = EntityCodec.booleanCodec(Key.key((String)"creeper", (String)"powered"), Creeper.class).getter(Creeper::isPowered).setter(Creeper::setPowered).build();
    private static final EntityCodec<?, ?> MAX_FUSE_TICKS = EntityCodec.intCodec(Key.key((String)"creeper", (String)"max_fuse_ticks"), Creeper.class).getter(Creeper::getMaxFuseTicks).setter(Creeper::setMaxFuseTicks).build();
    private static final EntityCodec<?, ?> EXPLOSION_RADIUS = EntityCodec.intCodec(Key.key((String)"creeper", (String)"explosion_radius"), Creeper.class).getter(Creeper::getExplosionRadius).setter(Creeper::setExplosionRadius).build();
    private static final EntityCodec<?, ?> ABSORPTION_AMOUNT = EntityCodec.doubleCodec(Key.key((String)"damageable", (String)"absorption_amount"), Damageable.class).getter(Damageable::getAbsorptionAmount).setter(Damageable::setAbsorptionAmount).build();
    private static final EntityCodec<?, ?> SCREAMING = EntityCodec.booleanCodec(Key.key((String)"enderman", (String)"screaming"), Enderman.class).getter(Enderman::isScreaming).setter(Enderman::setScreaming).build();
    private static final EntityCodec<?, ?> STARED_AT = EntityCodec.booleanCodec(Key.key((String)"enderman", (String)"stared_at"), Enderman.class).getter(Enderman::hasBeenStaredAt).setter(Enderman::setHasBeenStaredAt).build();
    private static final EntityCodec<?, ?> CARRIED_BLOCK = EntityCodec.builder(Key.key((String)"enderman", (String)"carried_block"), Enderman.class, BlockData.class).getter(Enderman::getCarriedBlock).setter(Enderman::setCarriedBlock).adapter(new BlockDataAdapter(plugin.getServer())).argumentType((ArgumentType<BlockData>)new BlockDataArgumentType()).build();
    private static final EntityCodec<?, ?> VISUAL_FIRE = EntityCodec.enumCodec(Key.key((String)"entity", (String)"visual_fire"), Entity.class, TriState.class).getter(Entity::getVisualFire).setter((entity, triState) -> entity.setVisualFire(triState)).build();
    private static final EntityCodec<?, ?> FIRE_TICKS = EntityCodec.intCodec(Key.key((String)"entity", (String)"fire_ticks"), Entity.class).getter(Entity::getFireTicks).setter(Entity::setFireTicks).build();
    private static final EntityCodec<?, ?> GLOWING = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"glowing"), Entity.class).getter(Entity::isGlowing).setter(Entity::setGlowing).build();
    private static final EntityCodec<?, ?> GRAVITY = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"gravity"), Entity.class).getter(Entity::hasGravity).setter(Entity::setGravity).build();
    private static final EntityCodec<?, ?> INVISIBLE = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"invisible"), Entity.class).getter(Entity::isInvisible).setter(Entity::setInvisible).build();
    private static final EntityCodec<?, ?> INVULNERABLE = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"invulnerable"), Entity.class).getter(Entity::isInvulnerable).setter(Entity::setInvulnerable).build();
    private static final EntityCodec<?, ?> NO_PHYSICS = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"no_physics"), Entity.class).getter(Entity::hasNoPhysics).setter(Entity::setNoPhysics).build();
    private static final EntityCodec<?, ?> POSE = EntityCodec.enumCodec(Key.key((String)"entity", (String)"pose"), Entity.class, Pose.class).getter(Entity::getPose).setter((entity, pose) -> entity.setPose(pose, true)).build();
    private static final EntityCodec<?, ?> FREEZE_TICKS = EntityCodec.intCodec(Key.key((String)"entity", (String)"freeze_ticks"), Entity.class).getter(Entity::getFreezeTicks).setter(Entity::setFreezeTicks).build();
    private static final EntityCodec<?, ?> LOCK_FREEZE_TICKS = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"lock_freeze_ticks"), Entity.class).getter(Entity::isFreezeTickingLocked).setter(Entity::lockFreezeTicks).build();
    private static final EntityCodec<?, ?> SILENT = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"silent"), Entity.class).getter(Entity::isSilent).setter(Entity::setSilent).build();
    private static final EntityCodec<?, ?> SNEAKING = EntityCodec.booleanCodec(Key.key((String)"entity", (String)"sneaking"), Entity.class).getter(Entity::isSneaking).setter(Entity::setSneaking).build();
    private static final EntityCodec<?, ?> CROUCHING = EntityCodec.booleanCodec(Key.key((String)"fox", (String)"crouching"), Fox.class).getter(Fox::isCrouching).setter(Fox::setCrouching).build();
    private static final EntityCodec<?, ?> LEAPING = EntityCodec.booleanCodec(Key.key((String)"fox", (String)"leaping"), Fox.class).getter(Fox::isLeaping).setter(Fox::setLeaping).build();
    private static final EntityCodec<?, ?> SLEEPING = EntityCodec.booleanCodec(Key.key((String)"fox", (String)"sleeping"), Fox.class).getter(LivingEntity::isSleeping).setter(Fox::setSleeping).build();
    private static final EntityCodec<?, ?> VARIANT = EntityCodec.enumCodec(Key.key((String)"fox", (String)"variant"), Fox.class, Fox.Type.class).getter(Fox::getFoxType).setter(Fox::setFoxType).build();
    private static final EntityCodec<?, ?> GLIDING = EntityCodec.booleanCodec(Key.key((String)"living_entity", (String)"gliding"), LivingEntity.class).getter(LivingEntity::isGliding).setter(LivingEntity::setGliding).build();
    private static final EntityCodec<?, ?> EQUIPMENT = EntityCodec.builder(Key.key((String)"living_entity", (String)"equipment"), LivingEntity.class, PaperEntityEquipment.class).getter(PaperEntityEquipment::of).setter((livingEntity, paperEntityEquipment) -> paperEntityEquipment.apply((LivingEntity)livingEntity)).adapter(new EntityEquipmentAdapter()).build();
    private static final EntityCodec<?, ?> AI = EntityCodec.booleanCodec(Key.key((String)"living_entity", (String)"ai"), LivingEntity.class).getter(LivingEntity::hasAI).setter(LivingEntity::setAI).build();
    private static final EntityCodec<?, ?> ARROWS_IN_BODY = EntityCodec.intCodec(Key.key((String)"living_entity", (String)"arrows_in_body"), LivingEntity.class).getter(LivingEntity::getArrowsInBody).setter((livingEntity, arrows) -> livingEntity.setArrowsInBody(arrows.intValue(), false)).build();
    private static final EntityCodec<?, ?> BEE_STINGERS_IN_BODY = EntityCodec.intCodec(Key.key((String)"living_entity", (String)"bee_stingers_in_body"), LivingEntity.class).getter(LivingEntity::getBeeStingersInBody).setter(LivingEntity::setBeeStingersInBody).build();
    private static final EntityCodec<?, ?> BODY_YAW = EntityCodec.floatCodec(Key.key((String)"living_entity", (String)"body_yaw"), LivingEntity.class).getter(LivingEntity::getBodyYaw).setter(LivingEntity::setBodyYaw).build();
    private static final EntityCodec<?, ?> HEALTH = EntityCodec.doubleCodec(Key.key((String)"living_entity", (String)"health"), LivingEntity.class).getter(Damageable::getHealth).setter(Damageable::setHealth).build();
    private static final EntityCodec<?, ?> COLLIDABLE = EntityCodec.booleanCodec(Key.key((String)"living_entity", (String)"collidable"), LivingEntity.class).getter(LivingEntity::isCollidable).setter(LivingEntity::setCollidable).build();
    private static final EntityCodec<?, ?> AGGRESSIVE = EntityCodec.booleanCodec(Key.key((String)"mob", (String)"aggressive"), Mob.class).getter(Mob::isAggressive).setter(Mob::setAggressive).build();
    private static final EntityCodec<?, ?> AWARE = EntityCodec.booleanCodec(Key.key((String)"mob", (String)"aware"), Mob.class).getter(Mob::isAware).setter(Mob::setAware).build();
    private static final EntityCodec<?, ?> LEFT_HANDED = EntityCodec.booleanCodec(Key.key((String)"mob", (String)"left_handed"), Mob.class).getter(Mob::isLeftHanded).setter(Mob::setLeftHanded).build();
    private static final EntityCodec<?, ?> SITTING = EntityCodec.booleanCodec(Key.key((String)"sittable", (String)"sitting"), Sittable.class).getter(Sittable::isSitting).setter(Sittable::setSitting).build();
    private static final EntityCodec<?, ?> SADDLE = EntityCodec.booleanCodec(Key.key((String)"steerable", (String)"saddled"), Steerable.class).getter(Steerable::hasSaddle).setter(Steerable::setSaddle).build();
    private static final EntityCodec<?, ?> TAMED = EntityCodec.booleanCodec(Key.key((String)"tameable", (String)"tamed"), Tameable.class).getter(Tameable::isTamed).setter(Tameable::setTamed).build();

    public static void registerAll() {
        EntityCodecRegistry.registry().registerAll(List.of(SKIN_PARTS, RESOLVABLE_PROFILE, IMMOVABLE, MAIN_HAND, BASE_PLATE, VISIBLE, ARMS, SMALL, MARKER, CAN_MOVE, CAN_TICK, AGE, BASE_POTION_TYPE, AREA_EFFECT_CLOUD_COLOR, DURATION_ON_USE, DURATION, PARTICLE, ATTRIBUTES, RADIUS, REAPPLICATION_DELAY, WAIT_TIME, ARROW_COLOR, HEAD_UP, LYING_DOWN, CAT_VARIANT, DANCING, CAN_DUPLICATE, DUPLICATION_COOLDOWN, COLLAR_COLOR, POWERED, MAX_FUSE_TICKS, EXPLOSION_RADIUS, ABSORPTION_AMOUNT, SCREAMING, STARED_AT, CARRIED_BLOCK, VISUAL_FIRE, FIRE_TICKS, GLOWING, GRAVITY, INVISIBLE, INVULNERABLE, NO_PHYSICS, POSE, FREEZE_TICKS, LOCK_FREEZE_TICKS, SILENT, SNEAKING, CROUCHING, LEAPING, SLEEPING, VARIANT, GLIDING, EQUIPMENT, AI, ARROWS_IN_BODY, BEE_STINGERS_IN_BODY, BODY_YAW, COLLIDABLE, AGGRESSIVE, AWARE, LEFT_HANDED, SITTING, SADDLE, TAMED));
    }

    private static <E, T extends Keyed> EntityCodec.Builder<E, T> registryCodec(Key key, Class<E> entityType, Class<T> type, RegistryKey<T> registryKey) {
        return EntityCodec.builder(key, entityType, type).argumentType(ArgumentTypes.resource(registryKey)).adapter(new RegistryAdapter<T>(registryKey));
    }
}

