/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.character;

import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import core.io.IO;
import core.io.PathIO;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.codec.EntityCodec;
import net.thenextlvl.character.codec.EntityCodecRegistry;
import net.thenextlvl.character.goal.Goal;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.model.EmptyLootTable;
import net.thenextlvl.character.tag.TagOptions;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagDeserializer;
import net.thenextlvl.nbt.tag.ByteTag;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperCharacter<E extends Entity>
implements Character<E>,
TagDeserializer<Character<E>> {
    protected final Class<? extends E> entityClass;
    protected final Map<String, ClickAction<?>> actions = new LinkedHashMap();
    protected final Set<Goal> goals = new HashSet<Goal>();
    protected final Set<UUID> viewers = new HashSet<UUID>();
    protected final TagOptions tagOptions = new PaperTagOptions();
    protected final CharacterPlugin plugin;
    protected final EntityType type;
    protected final String name;
    protected @Nullable E entity = null;
    protected @Nullable Component displayName;
    protected @Nullable Location spawnLocation = null;
    protected @Nullable NamedTextColor teamColor = null;
    protected @Nullable String viewPermission = null;
    protected @Nullable TextDisplay textDisplayName = null;
    public @Nullable CompoundTag entityData = null;
    protected Pose pose = Pose.STANDING;
    protected boolean displayNameVisible = true;
    protected boolean persistent = true;
    protected boolean visibleByDefault = true;

    public PaperCharacter(CharacterPlugin plugin, String name, EntityType type) {
        Class entityClass = type.getEntityClass();
        Preconditions.checkArgument((entityClass != null ? 1 : 0) != 0, (String)"Cannot spawn entity of type %s", (Object)type);
        this.entityClass = entityClass;
        this.displayName = Component.text((String)name);
        this.name = name;
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public Optional<ClickAction<?>> getAction(String name) {
        return Optional.ofNullable(this.actions.get(name));
    }

    @Override
    public @Unmodifiable Map<String, ClickAction<?>> getActions() {
        return Map.copyOf(this.actions);
    }

    @Override
    public Optional<Component> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    public @Unmodifiable Set<Goal> getGoals() {
        return Set.copyOf(this.goals);
    }

    @Override
    public boolean addGoal(Goal goal) {
        return this.goals.add(goal);
    }

    @Override
    public boolean removeGoal(Goal goal) {
        return this.goals.remove(goal);
    }

    @Override
    public <V> Optional<V> getEntity(Class<V> type) {
        return this.getEntity().filter(type::isInstance).map(type::cast);
    }

    @Override
    public Optional<E> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    @Override
    public Class<? extends E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Optional<NamedTextColor> getTeamColor() {
        return Optional.ofNullable(this.teamColor);
    }

    @Override
    public Optional<Location> getLocation() {
        return this.getEntity().map(Entity::getLocation);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getViewPermission() {
        return Optional.ofNullable(this.viewPermission);
    }

    @Override
    public Optional<Location> getSpawnLocation() {
        return Optional.ofNullable(this.spawnLocation);
    }

    @Override
    public TagOptions getTagOptions() {
        return this.tagOptions;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    public @Unmodifiable Set<UUID> getViewers() {
        return Set.copyOf(this.viewers);
    }

    @Override
    public Optional<World> getWorld() {
        return this.getEntity().map(Entity::getWorld);
    }

    @Override
    public Optional<Pathfinder> getPathfinder() {
        return this.getEntity((Class)Mob.class).map(Mob::getPathfinder);
    }

    @Override
    public <T> boolean addAction(String name, ClickAction<T> action) {
        return action.getActionType().isApplicable(action.getInput(), this) && !action.equals(this.actions.put(name, action));
    }

    @Override
    public boolean addViewer(UUID player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        if (this.entity == null || this.isVisibleByDefault()) {
            return true;
        }
        Player online = this.plugin.getServer().getPlayer(player);
        if (online != null) {
            online.showEntity((Plugin)this.plugin, this.entity);
        }
        return true;
    }

    @Override
    public boolean addViewers(Collection<UUID> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean canSee(Player player) {
        if (this.entity == null || !this.isSpawned()) {
            return false;
        }
        if (!player.getWorld().equals((Object)this.entity.getWorld())) {
            return false;
        }
        if (this.viewPermission != null && !player.hasPermission(this.viewPermission)) {
            return false;
        }
        return this.isVisibleByDefault() || this.isViewer(player.getUniqueId());
    }

    @Override
    public boolean hasAction(ClickAction<?> action) {
        return this.actions.containsValue(action);
    }

    @Override
    public boolean hasAction(String name) {
        return this.actions.containsKey(name);
    }

    @Override
    public boolean isDisplayNameVisible() {
        return this.displayNameVisible;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public boolean isSpawned() {
        return this.entity != null && this.entity.isValid();
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.getEntity().map(entity -> entity.getTrackedBy().contains(player)).orElse(false);
    }

    @Override
    public boolean isViewer(UUID player) {
        return this.viewers.contains(player);
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    @Override
    public boolean persist() {
        boolean bl;
        if (!this.isPersistent()) {
            return false;
        }
        PathIO file = IO.of(this.file());
        PathIO backup = IO.of(this.backupFile());
        if (file.exists(new LinkOption[0])) {
            Files.move(file.getPath(), backup.getPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            file.createParents(new FileAttribute[0]);
        }
        NBTOutputStream outputStream = new NBTOutputStream(file.outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8);
        try {
            outputStream.writeTag(this.getName(), this.plugin.nbt().serialize(this));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                if (backup.exists(new LinkOption[0])) {
                    try {
                        Files.copy(backup.getPath(), file.getPath(), StandardCopyOption.REPLACE_EXISTING);
                        this.plugin.getComponentLogger().warn("Recovered {} from potential data loss", (Object)this.getName());
                    }
                    catch (IOException e) {
                        this.plugin.getComponentLogger().error("Failed to restore character {}", (Object)this.getName(), (Object)e);
                    }
                }
                this.plugin.getComponentLogger().error("Failed to save character {}", (Object)this.getName(), (Object)t);
                this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/characters/issues/new");
                return false;
            }
        }
        outputStream.close();
        return bl;
    }

    @Override
    public boolean removeAction(String name) {
        return this.actions.remove(name) != null;
    }

    @Override
    public boolean removeViewer(UUID player) {
        if (!this.viewers.remove(player)) {
            return false;
        }
        if (this.entity == null || this.isVisibleByDefault()) {
            return true;
        }
        Player online = this.plugin.getServer().getPlayer(player);
        if (online != null) {
            online.hideEntity((Plugin)this.plugin, this.entity);
        }
        return true;
    }

    @Override
    public boolean removeViewers(Collection<UUID> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean setDisplayName(@Nullable Component displayName) {
        if (Objects.equals(displayName, this.displayName)) {
            return false;
        }
        this.displayName = displayName;
        this.getEntity().ifPresent(this::updateTextDisplayName);
        return true;
    }

    @Override
    public boolean setDisplayNameVisible(boolean visible) {
        if (visible == this.displayNameVisible) {
            return false;
        }
        this.displayNameVisible = visible;
        this.getEntity().ifPresent(this::updateTextDisplayName);
        return true;
    }

    @Override
    public boolean setPersistent(boolean persistent) {
        if (persistent == this.persistent) {
            return false;
        }
        this.persistent = persistent;
        return true;
    }

    @Override
    public boolean setSpawnLocation(@Nullable Location location) {
        if (Objects.equals(location, this.spawnLocation)) {
            return false;
        }
        this.spawnLocation = location;
        return true;
    }

    @Override
    public boolean setTeamColor(@Nullable NamedTextColor color) {
        if (color == this.teamColor) {
            return false;
        }
        this.teamColor = color;
        this.textDisplayName().ifPresent(this::updateTextDisplayNameText);
        this.getEntity().ifPresent(this::updateTeamOptions);
        return true;
    }

    @Override
    public boolean setViewPermission(@Nullable String permission) {
        if (Objects.equals(permission, this.viewPermission)) {
            return false;
        }
        this.viewPermission = permission;
        this.getEntity().ifPresent(entity -> this.plugin.getServer().getOnlinePlayers().forEach(player -> this.updateVisibility((E)entity, (Player)player)));
        return true;
    }

    @Override
    public boolean setVisibleByDefault(boolean visible) {
        if (visible == this.visibleByDefault) {
            return false;
        }
        this.visibleByDefault = visible;
        this.getEntity().ifPresent(entity -> {
            entity.setVisibleByDefault(visible);
            if (this.textDisplayName != null) {
                this.textDisplayName.setVisibleByDefault(visible);
            }
            if (visible) {
                entity.getTrackedBy().forEach(player -> {
                    if (this.isViewer(player.getUniqueId())) {
                        return;
                    }
                    if (this.textDisplayName != null) {
                        player.hideEntity((Plugin)this.plugin, (Entity)this.textDisplayName);
                    }
                    player.hideEntity((Plugin)this.plugin, entity);
                });
            } else {
                this.getViewers().stream().map(arg_0 -> ((Server)this.plugin.getServer()).getPlayer(arg_0)).filter(Objects::nonNull).forEach(player -> {
                    if (this.textDisplayName != null) {
                        player.showEntity((Plugin)this.plugin, (Entity)this.textDisplayName);
                    }
                    player.showEntity((Plugin)this.plugin, entity);
                });
            }
        });
        return true;
    }

    public void loadCharacter(Player player) {
        this.getEntity().ifPresent(entity -> {
            this.updateTeamOptions(this.getCharacterSettingsTeam((Entity)entity, player));
            this.updateVisibility(entity, player);
        });
    }

    @Override
    public @Nullable E spawn() throws IllegalStateException {
        if (this.spawnLocation == null) {
            return null;
        }
        return this.spawn(this.spawnLocation);
    }

    @Override
    public E spawn(Location location) throws IllegalStateException {
        Preconditions.checkState((!this.isSpawned() ? 1 : 0) != 0, (String)"Character '%s' is already spawned", (Object)this.name);
        Preconditions.checkState((boolean)location.isChunkLoaded(), (String)"Chunk at %s, %s in %s is not loaded", (Object)(location.getBlockX() >> 4), (Object)(location.getBlockZ() >> 4), (Object)location.getWorld().key());
        this.spawnLocation = location;
        this.entity = location.getWorld().spawn(location, this.entityClass, this::preSpawn);
        if (this.viewPermission != null || !this.visibleByDefault) {
            this.plugin.getServer().getOnlinePlayers().forEach(player -> this.updateVisibility(this.entity, (Player)player));
        }
        this.updateTextDisplayName(this.entity);
        this.updateTeamOptions(this.entity);
        return this.entity;
    }

    @Override
    public @Nullable E respawn() throws IllegalStateException {
        if (this.spawnLocation == null) {
            return null;
        }
        return this.respawn(this.spawnLocation);
    }

    @Override
    public E respawn(Location location) throws IllegalStateException {
        this.remove();
        return this.spawn(location);
    }

    @Override
    public void delete() {
        this.remove();
        this.backupFile().delete();
        this.file().delete();
        this.plugin.characterController().unregister(this.name);
    }

    @Override
    public void remove() {
        if (this.entity != null) {
            this.entity.remove();
        }
        this.invalidate();
    }

    public void invalidate() {
        this.removeTextDisplayName();
        if (this.entity != null) {
            this.plugin.getServer().getOnlinePlayers().forEach(player -> {
                Team team = player.getScoreboard().getTeam(this.entity.getScoreboardEntryName());
                if (team != null) {
                    team.unregister();
                }
            });
        }
        this.entity = null;
    }

    @Override
    public Character<E> deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        root.optional("entityData").map(Tag::getAsCompound).ifPresent(entityData -> {
            this.entityData = entityData;
        });
        root.optional("clickActions").map(Tag::getAsCompound).ifPresent(actions -> actions.forEach((name, action) -> this.addAction((String)name, this.plugin.nbt().deserialize((Tag)action, ClickAction.class))));
        root.optional("displayName").map(t -> this.plugin.nbt().deserialize((Tag)t, Component.class)).ifPresentOrElse(this::setDisplayName, () -> this.setDisplayName(null));
        root.optional("displayNameVisible").map(Tag::getAsBoolean).ifPresent(this::setDisplayNameVisible);
        root.optional("tagOptions").ifPresent(this.tagOptions::deserialize);
        root.optional("teamColor").map(t -> this.plugin.nbt().deserialize((Tag)t, NamedTextColor.class)).ifPresent(this::setTeamColor);
        root.optional("viewPermission").map(Tag::getAsString).ifPresent(this::setViewPermission);
        root.optional("visibleByDefault").map(Tag::getAsBoolean).ifPresent(this::setVisibleByDefault);
        try {
            root.optional("location").map(location -> context.deserialize((Tag)location, Location.class)).ifPresent(this::setSpawnLocation);
        }
        catch (ParserException e) {
            this.plugin.getComponentLogger().warn("Failed to read location of character '{}': {}", (Object)this.name, (Object)e.getMessage());
        }
        return this;
    }

    public void updateVisibility(E entity, Player player) {
        if (this.canSee(player)) {
            if (this.textDisplayName != null) {
                player.showEntity((Plugin)this.plugin, (Entity)this.textDisplayName);
            }
            player.showEntity((Plugin)this.plugin, entity);
        } else {
            if (this.textDisplayName != null) {
                player.hideEntity((Plugin)this.plugin, (Entity)this.textDisplayName);
            }
            player.hideEntity((Plugin)this.plugin, entity);
        }
    }

    private Optional<TextDisplay> textDisplayName() {
        return Optional.ofNullable(this.textDisplayName);
    }

    protected void preSpawn(E entity) {
        try {
            this.internalPreSpawn(entity);
        }
        catch (Exception t) {
            this.plugin.getComponentLogger().error("Failed to spawn character {}", (Object)this.getName(), (Object)t);
            entity.remove();
        }
    }

    protected void internalPreSpawn(E entity) {
        Attributable attributable;
        AttributeInstance attribute;
        entity.setVisibleByDefault(this.visibleByDefault);
        entity.setGravity(false);
        entity.setInvulnerable(true);
        entity.setSilent(true);
        entity.setPersistent(false);
        if (entity instanceof Mannequin) {
            Mannequin mannequin = (Mannequin)entity;
            mannequin.setProfile((ResolvableProfile)ResolvableProfile.resolvableProfile().name(this.name).build());
            mannequin.setImmovable(true);
        }
        if (entity instanceof TNTPrimed) {
            TNTPrimed primed = (TNTPrimed)entity;
            primed.setFuseTicks(Integer.MAX_VALUE);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.setAI(false);
            living.setCanPickupItems(false);
            living.setRemoveWhenFarAway(false);
            AttributeInstance instance = living.getAttribute(Attribute.MAX_HEALTH);
            if (instance != null) {
                living.setHealth(instance.getValue());
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setLootTable(EmptyLootTable.INSTANCE);
            mob.setDespawnInPeacefulOverride(TriState.FALSE);
        }
        if (entity instanceof Attributable && (attribute = (attributable = (Attributable)entity).getAttribute(Attribute.WAYPOINT_TRANSMIT_RANGE)) != null) {
            attribute.setBaseValue(0.0);
        }
        if (this.entityData != null) {
            EntityCodecRegistry.registry().codecs().forEach(entityCodec -> {
                if (!entityCodec.entityType().isInstance(entity)) {
                    return;
                }
                EntityCodec codec = entityCodec;
                this.entityData.optional(entityCodec.key().asString()).map(tag1 -> {
                    ByteTag byteTag;
                    return tag1 instanceof ByteTag && (byteTag = (ByteTag)tag1).getAsByte() == -1 ? null : codec.adapter().deserialize((Tag)tag1, this.plugin.nbt());
                }).ifPresent(data -> codec.setter().test(entity, (Entity)data));
            });
        }
        this.entityData = null;
        if (entity.getPose().equals((Object)Pose.DYING)) {
            entity.setPose(Pose.STANDING, true);
        }
    }

    protected Team getCharacterSettingsTeam(Entity entity, Player player) {
        Team characterSettings = player.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (characterSettings != null) {
            return characterSettings;
        }
        characterSettings = player.getScoreboard().registerNewTeam(entity.getScoreboardEntryName());
        characterSettings.addEntry(entity.getScoreboardEntryName());
        return characterSettings;
    }

    protected void removeTextDisplayName() {
        if (this.textDisplayName == null) {
            return;
        }
        this.textDisplayName.remove();
        this.textDisplayName = null;
    }

    private void updateTextDisplayName(TextDisplay display) {
        display.setAlignment(this.tagOptions.getAlignment());
        display.setBackgroundColor(this.tagOptions.getBackgroundColor());
        display.setBillboard(this.tagOptions.getBillboard());
        display.setBrightness(this.tagOptions.getBrightness());
        display.setDefaultBackground(this.tagOptions.isDefaultBackground());
        display.setLineWidth(this.tagOptions.getLineWidth());
        display.setGravity(false);
        display.setPersistent(false);
        display.setSeeThrough(this.tagOptions.isSeeThrough());
        display.setShadowed(this.tagOptions.hasTextShadow());
        display.setTransformation(new Transformation(this.tagOptions.getOffset(), this.tagOptions.getLeftRotation(), this.tagOptions.getScale(), this.tagOptions.getRightRotation()));
        display.setVisibleByDefault(this.visibleByDefault);
        this.updateTextDisplayNameOpacity(display);
        this.updateTextDisplayNameText(display);
    }

    private void updateTextDisplayNameText(TextDisplay display) {
        Component component = this.displayName == null ? Component.text((String)this.getName()) : this.displayName;
        display.text(component.colorIfAbsent((TextColor)this.teamColor));
    }

    private void updateTextDisplayNameOpacity(TextDisplay display) {
        display.setTextOpacity((byte)Math.round(25.0f + (100.0f - this.tagOptions.getTextOpacity()) * 2.3f));
    }

    protected void updateTextDisplayName(E entity) {
        if (this.textDisplayName == null && this.showDisplayName()) {
            this.textDisplayName = (TextDisplay)entity.getWorld().spawn(entity.getLocation(), TextDisplay.class, display -> {
                entity.addPassenger((Entity)display);
                this.updateTextDisplayName((TextDisplay)display);
            });
        } else if (this.textDisplayName != null && !this.showDisplayName()) {
            this.removeTextDisplayName();
        } else if (this.textDisplayName != null) {
            this.updateTextDisplayName(this.textDisplayName);
        }
    }

    protected boolean showDisplayName() {
        return this.displayName != null && this.displayNameVisible;
    }

    public void updateTeamOptions(E entity) {
        entity.getTrackedBy().forEach(player -> this.updateTeamOptions(this.getCharacterSettingsTeam((Entity)entity, (Player)player)));
    }

    protected void updateTeamOptions(Team team) {
        team.color(this.teamColor);
        Boolean collidable = this.getEntity((Class)LivingEntity.class).map(LivingEntity::isCollidable).orElse(false);
        team.setOption(Team.Option.COLLISION_RULE, collidable != false ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
    }

    private File backupFile() {
        return new File(this.plugin.savesFolder(), this.name + ".dat_old");
    }

    private File file() {
        return new File(this.plugin.savesFolder(), this.name + ".dat");
    }

    private class PaperTagOptions
    implements TagOptions {
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Display.Brightness brightness = null;
        private @Nullable Color backgroundColor = null;
        private Display.Billboard billboard = Display.Billboard.CENTER;
        private Quaternionf leftRotation = new Quaternionf();
        private Quaternionf rightRotation = new Quaternionf();
        private TextDisplay.TextAlignment alignment = TextDisplay.TextAlignment.CENTER;
        private Vector3f offset = new Vector3f(0.0f, 0.27f, 0.0f);
        private Vector3f scale = new Vector3f(1.0f);
        private boolean defaultBackground = false;
        private boolean seeThrough = false;
        private boolean textShadow = false;
        private float textOpacity;
        private int lineWidth = 200;

        private PaperTagOptions() {
        }

        @Override
        public Display.Billboard getBillboard() {
            return this.billboard;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Display.Brightness getBrightness() {
            return this.brightness;
        }

        @Override
        public @Nullable Color getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public Quaternionf getLeftRotation() {
            return this.leftRotation;
        }

        @Override
        public Quaternionf getRightRotation() {
            return this.rightRotation;
        }

        @Override
        public TextDisplay.TextAlignment getAlignment() {
            return this.alignment;
        }

        @Override
        public Vector3f getOffset() {
            return this.offset;
        }

        @Override
        public Vector3f getScale() {
            return this.scale;
        }

        @Override
        public boolean hasTextShadow() {
            return this.textShadow;
        }

        @Override
        public boolean isDefaultBackground() {
            return this.defaultBackground;
        }

        @Override
        public boolean isSeeThrough() {
            return this.seeThrough;
        }

        @Override
        public boolean setAlignment(TextDisplay.TextAlignment alignment) {
            if (Objects.equals(alignment, this.alignment)) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setAlignment(alignment));
            this.alignment = alignment;
            return true;
        }

        @Override
        public boolean setBackgroundColor(@Nullable Color color) {
            if (Objects.equals(color, this.backgroundColor)) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setBackgroundColor(color));
            this.backgroundColor = color;
            return true;
        }

        @Override
        public boolean setBillboard(Display.Billboard billboard) {
            if (Objects.equals(billboard, this.billboard)) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setBillboard(billboard));
            this.billboard = billboard;
            return true;
        }

        @Override
        public boolean setBrightness(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Display.Brightness brightness) {
            if (Objects.equals(brightness, this.brightness)) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setBrightness(brightness));
            this.brightness = brightness;
            return true;
        }

        @Override
        public boolean setDefaultBackground(boolean enabled) {
            if (enabled == this.defaultBackground) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setDefaultBackground(enabled));
            this.defaultBackground = enabled;
            return true;
        }

        @Override
        public boolean setLeftRotation(Quaternionf rotation) {
            if (Objects.equals(rotation, this.leftRotation)) {
                return false;
            }
            this.leftRotation = rotation;
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setTransformation(this.getTransformation()));
            return true;
        }

        @Override
        public boolean setLineWidth(int width) {
            if (width == this.lineWidth) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setLineWidth(width));
            this.lineWidth = width;
            return true;
        }

        @Override
        public boolean setOffset(Vector3f offset) {
            if (Objects.equals(offset, this.offset)) {
                return false;
            }
            this.offset = offset;
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setTransformation(this.getTransformation()));
            return true;
        }

        @Override
        public boolean setOffsetX(float offset) {
            return this.setOffset(new Vector3f(offset, this.offset.y(), this.offset.z()));
        }

        @Override
        public boolean setOffsetY(float offset) {
            return this.setOffset(new Vector3f(this.offset.x(), offset, this.offset.z()));
        }

        @Override
        public boolean setOffsetZ(float offset) {
            return this.setOffset(new Vector3f(this.offset.x(), this.offset.y(), offset));
        }

        @Override
        public boolean setRightRotation(Quaternionf rotation) {
            if (Objects.equals(rotation, this.rightRotation)) {
                return false;
            }
            this.rightRotation = rotation;
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setTransformation(this.getTransformation()));
            return true;
        }

        @Override
        public boolean setScale(Vector3f scale) {
            if (Objects.equals(scale, this.scale)) {
                return false;
            }
            this.scale = scale;
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setTransformation(this.getTransformation()));
            return true;
        }

        private Transformation getTransformation() {
            return new Transformation(this.offset, this.leftRotation, this.scale, this.rightRotation);
        }

        @Override
        public boolean setScale(float scale) {
            return this.setScale(new Vector3f(scale));
        }

        @Override
        public boolean setSeeThrough(boolean seeThrough) {
            if (seeThrough == this.seeThrough) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setSeeThrough(seeThrough));
            this.seeThrough = seeThrough;
            return true;
        }

        @Override
        public boolean setTextOpacity(float opacity) {
            if (opacity == this.textOpacity) {
                return false;
            }
            this.textOpacity = opacity;
            PaperCharacter.this.textDisplayName().ifPresent(PaperCharacter.this::updateTextDisplayNameOpacity);
            return true;
        }

        @Override
        public boolean setTextShadow(boolean enabled) {
            if (enabled == this.textShadow) {
                return false;
            }
            PaperCharacter.this.textDisplayName().ifPresent(display -> display.setShadowed(enabled));
            this.textShadow = enabled;
            return true;
        }

        @Override
        public float getTextOpacity() {
            return this.textOpacity;
        }

        @Override
        public int getLineWidth() {
            return this.lineWidth;
        }

        @Override
        public Tag serialize() throws ParserException {
            CompoundTag tag = CompoundTag.empty();
            if (this.backgroundColor != null) {
                tag.add("backgroundColor", this.backgroundColor.asARGB());
            }
            if (this.brightness != null) {
                tag.add("brightness", PaperCharacter.this.plugin.nbt().serialize(this.brightness));
            }
            tag.add("alignment", this.alignment.name());
            tag.add("billboard", this.billboard.name());
            tag.add("defaultBackground", this.defaultBackground);
            tag.add("leftRotation", PaperCharacter.this.plugin.nbt().serialize(this.leftRotation));
            tag.add("lineWidth", this.lineWidth);
            tag.add("offset", PaperCharacter.this.plugin.nbt().serialize(this.offset));
            tag.add("rightRotation", PaperCharacter.this.plugin.nbt().serialize(this.rightRotation));
            tag.add("scale", PaperCharacter.this.plugin.nbt().serialize(this.scale));
            tag.add("seeThrough", this.seeThrough);
            tag.add("textOpacity", Float.valueOf(this.textOpacity));
            tag.add("textShadow", this.textShadow);
            return tag;
        }

        @Override
        public void deserialize(Tag tag) throws ParserException {
            CompoundTag root = tag.getAsCompound();
            root.optional("alignment").map(Tag::getAsString).map(TextDisplay.TextAlignment::valueOf).ifPresent(this::setAlignment);
            root.optional("billboard").map(Tag::getAsString).map(Display.Billboard::valueOf).ifPresent(this::setBillboard);
            root.optional("defaultBackground").map(Tag::getAsBoolean).ifPresent(this::setDefaultBackground);
            root.optional("leftRotation").map(t -> PaperCharacter.this.plugin.nbt().deserialize((Tag)t, Quaternionf.class)).ifPresent(this::setLeftRotation);
            root.optional("lineWidth").map(Tag::getAsInt).ifPresent(this::setLineWidth);
            root.optional("offset").map(t -> PaperCharacter.this.plugin.nbt().deserialize((Tag)t, Vector3f.class)).ifPresent(this::setOffset);
            root.optional("rightRotation").map(t -> PaperCharacter.this.plugin.nbt().deserialize((Tag)t, Quaternionf.class)).ifPresent(this::setRightRotation);
            root.optional("scale").map(t -> PaperCharacter.this.plugin.nbt().deserialize((Tag)t, Vector3f.class)).ifPresent(this::setScale);
            root.optional("seeThrough").map(Tag::getAsBoolean).ifPresent(this::setSeeThrough);
            root.optional("textOpacity").map(Tag::getAsFloat).ifPresent(this::setTextOpacity);
            root.optional("textShadow").map(Tag::getAsBoolean).ifPresent(this::setTextShadow);
            this.setBackgroundColor(root.optional("backgroundColor").map(Tag::getAsInt).map(Color::fromARGB).orElse(null));
            this.setBrightness(root.optional("brightness").map(t -> PaperCharacter.this.plugin.nbt().deserialize((Tag)t, Display.Brightness.class)).orElse(null));
        }
    }
}

