/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.mineskin;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.thenextlvl.character.mineskin.MineSkinClient;
import net.thenextlvl.character.mineskin.data.JobInfo;
import net.thenextlvl.character.mineskin.data.JobReference;
import net.thenextlvl.character.mineskin.data.JobStatus;
import net.thenextlvl.character.mineskin.exception.MineskinException;
import net.thenextlvl.character.mineskin.options.IJobCheckOptions;

public class JobChecker {
    private final MineSkinClient client;
    private JobInfo jobInfo;
    private final ScheduledExecutorService executor;
    private CompletableFuture<JobReference> future;
    private final AtomicInteger attempts = new AtomicInteger(0);
    private final int maxAttempts;
    private final int initialDelay;
    private final int interval;
    private final TimeUnit timeUnit;

    public JobChecker(MineSkinClient client, JobInfo jobInfo, ScheduledExecutorService executor, int maxAttempts, int initialDelaySeconds, int intervalSeconds) {
        this(client, jobInfo, executor, maxAttempts, initialDelaySeconds, intervalSeconds, TimeUnit.SECONDS);
    }

    public JobChecker(MineSkinClient client, JobInfo jobInfo, IJobCheckOptions options) {
        this(client, jobInfo, options.scheduler(), options.maxAttempts(), options.initialDelayMillis(), options.intervalMillis(), TimeUnit.MILLISECONDS);
    }

    public JobChecker(MineSkinClient client, JobInfo jobInfo, ScheduledExecutorService executor, int maxAttempts, int initialDelay, int interval, TimeUnit timeUnit) {
        this.client = client;
        this.jobInfo = jobInfo;
        this.executor = executor;
        this.maxAttempts = maxAttempts;
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public CompletableFuture<JobReference> check() {
        this.future = new CompletableFuture();
        this.executor.schedule(this::checkJob, (long)this.initialDelay, this.timeUnit);
        return this.future;
    }

    private void checkJob() {
        if (this.attempts.incrementAndGet() > this.maxAttempts) {
            this.future.completeExceptionally(new MineskinException("Max attempts reached"));
            return;
        }
        ((CompletableFuture)this.client.queue().get(this.jobInfo).thenAccept(response -> {
            JobInfo info = (JobInfo)response.getBody();
            if (info != null) {
                this.jobInfo = info;
            }
            if (this.jobInfo.status() == JobStatus.COMPLETED || this.jobInfo.status() == JobStatus.FAILED) {
                this.future.complete((JobReference)response);
            } else {
                this.executor.schedule(this::checkJob, (long)this.interval, this.timeUnit);
            }
        })).exceptionally(throwable -> {
            this.future.completeExceptionally((Throwable)throwable);
            return null;
        });
    }
}

