/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.codec;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import core.paper.command.argument.DurationArgumentType;
import core.paper.command.argument.EnumArgumentType;
import core.paper.command.argument.codec.EnumStringCodec;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.thenextlvl.character.codec.EntityCodec;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.adapter.BooleanAdapter;
import net.thenextlvl.nbt.serialization.adapter.DoubleAdapter;
import net.thenextlvl.nbt.serialization.adapter.DurationAdapter;
import net.thenextlvl.nbt.serialization.adapter.EnumAdapter;
import net.thenextlvl.nbt.serialization.adapter.FloatAdapter;
import net.thenextlvl.nbt.serialization.adapter.IntegerAdapter;
import net.thenextlvl.nbt.serialization.adapter.LongAdapter;
import net.thenextlvl.nbt.serialization.adapter.StringAdapter;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class SimpleEntityCodec<E, T>
implements EntityCodec<E, T> {
    private final Key key;
    private final Class<E> entityType;
    private final Class<? super T> valueType;
    private final Function<E, T> getter;
    private final BiPredicate<E, T> setter;
    private final @Nullable ArgumentType<T> argumentType;
    private final TagAdapter<T> adapter;

    SimpleEntityCodec(Key key, Class<E> entityType, Class<? super T> valueType, Function<E, T> getter, BiPredicate<E, T> setter, @Nullable ArgumentType<T> argumentType, TagAdapter<T> adapter) {
        this.key = key;
        this.entityType = entityType;
        this.valueType = valueType;
        this.getter = getter;
        this.setter = setter;
        this.argumentType = argumentType;
        this.adapter = adapter;
    }

    public Key key() {
        return this.key;
    }

    @Override
    public Class<E> entityType() {
        return this.entityType;
    }

    @Override
    public Class<T> valueType() {
        return this.valueType;
    }

    @Override
    public Function<E, T> getter() {
        return this.getter;
    }

    @Override
    public BiPredicate<E, T> setter() {
        return this.setter;
    }

    @Override
    public @Nullable ArgumentType<T> argumentType() {
        return this.argumentType;
    }

    @Override
    public TagAdapter<T> adapter() {
        return this.adapter;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleEntityCodec that = (SimpleEntityCodec)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public String toString() {
        return "SimpleEntityCodec{valueType=" + String.valueOf(this.valueType) + ", entityType=" + String.valueOf(this.entityType) + ", key=" + String.valueOf(this.key) + "}";
    }

    static <E> Builder<E, Boolean> booleanCodec(Key key, Class<E> entityType) {
        return ((Builder)new Builder<E, Boolean>(key, entityType, Boolean.TYPE).argumentType((ArgumentType)BoolArgumentType.bool())).adapter((TagAdapter)BooleanAdapter.INSTANCE);
    }

    static <E> Builder<E, Long> longCodec(Key key, Class<E> entityType, long min, long max) {
        return ((Builder)new Builder<E, Long>(key, entityType, Long.TYPE).argumentType((ArgumentType)LongArgumentType.longArg((long)min, (long)max))).adapter((TagAdapter)LongAdapter.INSTANCE);
    }

    static <E> Builder<E, Double> doubleCodec(Key key, Class<E> entityType, double min, double max) {
        return ((Builder)new Builder<E, Double>(key, entityType, Double.TYPE).argumentType((ArgumentType)DoubleArgumentType.doubleArg((double)min, (double)max))).adapter((TagAdapter)DoubleAdapter.INSTANCE);
    }

    static <E> Builder<E, Float> floatCodec(Key key, Class<E> entityType, float min, float max) {
        return ((Builder)new Builder<E, Float>(key, entityType, Float.TYPE).argumentType((ArgumentType)FloatArgumentType.floatArg((float)min, (float)max))).adapter((TagAdapter)FloatAdapter.INSTANCE);
    }

    static <E> Builder<E, Integer> intCodec(Key key, Class<E> entityType, int min, int max) {
        return ((Builder)new Builder<E, Integer>(key, entityType, Integer.TYPE).argumentType((ArgumentType)IntegerArgumentType.integer((int)min, (int)max))).adapter((TagAdapter)IntegerAdapter.INSTANCE);
    }

    static <E> Builder<E, String> stringCodec(Key key, Class<E> entityType) {
        return ((Builder)new Builder<E, String>(key, entityType, String.class).argumentType((ArgumentType)StringArgumentType.string())).adapter((TagAdapter)StringAdapter.INSTANCE);
    }

    static <E> Builder<E, Duration> durationCodec(Key key, Class<E> entityType, Duration minimum) {
        return ((Builder)new Builder<E, Duration>(key, entityType, Duration.class).argumentType((ArgumentType)DurationArgumentType.duration(minimum))).adapter((TagAdapter)DurationAdapter.INSTANCE);
    }

    static <E, T extends Enum<T>> Builder<E, T> enumCodec(Key key, Class<E> entityType, Class<T> enumType) {
        return ((Builder)new Builder<E, T>(key, entityType, enumType).argumentType((ArgumentType)EnumArgumentType.of(enumType, EnumStringCodec.lowerHyphen()))).adapter((TagAdapter)new EnumAdapter<T>(enumType));
    }

    static final class Builder<E, T>
    implements EntityCodec.Builder<E, T> {
        private final Key key;
        private final Class<E> entityType;
        private final Class<? super T> valueType;
        private @Nullable Function<E, T> getter;
        private @Nullable BiPredicate<E, T> setter;
        private @Nullable ArgumentType<T> argumentType;
        private @Nullable TagAdapter<T> adapter;

        Builder(Key key, Class<E> entityType, Class<? super T> valueType) {
            this.key = Objects.requireNonNull(key, "key");
            this.entityType = Objects.requireNonNull(entityType, "entityType");
            this.valueType = Objects.requireNonNull(valueType, "valueType");
        }

        @Override
        public Builder<E, T> getter(Function<E, T> getter) {
            this.getter = getter;
            return this;
        }

        @Override
        public Builder<E, T> setter(BiConsumer<E, T> setter) {
            return this.setter((T e, U t) -> {
                Preconditions.checkArgument((this.getter != null ? 1 : 0) != 0, (Object)"getter");
                T apply = this.getter.apply(e);
                setter.accept(e, t);
                return this.getter.apply(e) != apply;
            });
        }

        @Override
        public Builder<E, T> setter(BiPredicate<E, T> setter) {
            this.setter = setter;
            return this;
        }

        @Override
        public Builder<E, T> argumentType(ArgumentType<T> argumentType) {
            this.argumentType = argumentType;
            return this;
        }

        @Override
        public Builder<E, T> adapter(TagAdapter<T> adapter) {
            this.adapter = adapter;
            return this;
        }

        @Override
        public EntityCodec<E, T> build() {
            Preconditions.checkArgument((this.getter != null ? 1 : 0) != 0, (Object)"getter");
            Preconditions.checkArgument((this.setter != null ? 1 : 0) != 0, (Object)"setter");
            Preconditions.checkArgument((this.adapter != null ? 1 : 0) != 0, (Object)"adapter");
            return new SimpleEntityCodec<E, T>(this.key, this.entityType, this.valueType, this.getter, this.setter, this.argumentType, this.adapter);
        }
    }
}

