/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.codec;

import com.mojang.brigadier.arguments.ArgumentType;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.thenextlvl.character.codec.SimpleEntityCodec;
import net.thenextlvl.nbt.serialization.TagAdapter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface EntityCodec<E, T>
extends Keyed {
    @Contract(pure=true)
    public @NonNull Class<E> entityType();

    @Contract(pure=true)
    public @NonNull Class<T> valueType();

    @Contract(pure=true)
    public @NonNull Function<E, T> getter();

    @Contract(pure=true)
    public @NonNull BiPredicate<E, T> setter();

    @Contract(pure=true)
    public @Nullable ArgumentType<T> argumentType();

    @Contract(pure=true)
    public @NonNull TagAdapter<@NonNull T> adapter();

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E, T> @NonNull Builder<E, T> builder(@NonNull Key key, @NonNull Class<E> entityType, @NonNull Class<? super T> valueType) {
        return new SimpleEntityCodec.Builder<E, T>(key, entityType, valueType);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, String> stringCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return SimpleEntityCodec.stringCodec(key, entityType);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Duration> durationCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return EntityCodec.durationCodec(key, entityType, Duration.ZERO);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Duration> durationCodec(@NonNull Key key, @NonNull Class<E> entityType, @NonNull Duration minimum) {
        return SimpleEntityCodec.durationCodec(key, entityType, minimum);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E, T extends Enum<T>> @NonNull Builder<E, T> enumCodec(@NonNull Key key, @NonNull Class<E> entityType, @NonNull Class<T> enumType) {
        return SimpleEntityCodec.enumCodec(key, entityType, enumType);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Boolean> booleanCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return SimpleEntityCodec.booleanCodec(key, entityType);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Integer> intCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return EntityCodec.intCodec(key, entityType, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Integer> intCodec(@NonNull Key key, @NonNull Class<E> entityType, int min, int max) {
        return SimpleEntityCodec.intCodec(key, entityType, min, max);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Long> longCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return EntityCodec.longCodec(key, entityType, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Long> longCodec(@NonNull Key key, @NonNull Class<E> entityType, long min, long max) {
        return SimpleEntityCodec.longCodec(key, entityType, min, max);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Double> doubleCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return EntityCodec.doubleCodec(key, entityType, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Double> doubleCodec(@NonNull Key key, @NonNull Class<E> entityType, double min, double max) {
        return SimpleEntityCodec.doubleCodec(key, entityType, min, max);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Float> floatCodec(@NonNull Key key, @NonNull Class<E> entityType) {
        return EntityCodec.floatCodec(key, entityType, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static <E> @NonNull Builder<E, Float> floatCodec(@NonNull Key key, @NonNull Class<E> entityType, float min, float max) {
        return SimpleEntityCodec.floatCodec(key, entityType, min, max);
    }

    @ApiStatus.NonExtendable
    public static interface Builder<E, T> {
        @Contract(value="_ -> this", mutates="this")
        public @NonNull Builder<E, T> getter(@NonNull Function<E, @Nullable T> var1);

        @Contract(value="_ -> this", mutates="this")
        public @NonNull Builder<E, T> setter(@NonNull BiPredicate<E, T> var1);

        @Contract(value="_ -> this", mutates="this")
        public @NonNull Builder<E, T> setter(@NonNull BiConsumer<E, T> var1) throws IllegalArgumentException;

        @Contract(value="_ -> this", mutates="this")
        public @NonNull Builder<E, T> argumentType(@NonNull ArgumentType<T> var1);

        @Contract(value="_ -> this", mutates="this")
        public @NonNull Builder<E, T> adapter(@NonNull TagAdapter<@NonNull T> var1);

        @Contract(value="-> new", pure=true)
        public @NonNull EntityCodec<E, T> build() throws IllegalArgumentException;
    }
}

