/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.serialization;

import java.time.Duration;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.thenextlvl.character.action.ActionType;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.action.ClickType;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.StringTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ClickActionAdapter
implements TagAdapter<ClickAction<?>> {
    @Override
    public ClickAction<?> deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        String permission = root.optional("permission").map(Tag::getAsString).orElse(null);
        Duration cooldown = root.optional("cooldown").map(Tag::getAsLong).map(Duration::ofMillis).orElse(Duration.ZERO);
        ActionType actionType = context.deserialize((Tag)root.get("actionType"), ActionType.class);
        EnumSet clickTypes = root.getAsList("clickTypes").stream().map(Tag::getAsString).map(ClickType::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(ClickType.class)));
        Object input = context.deserialize((Tag)root.get("input"), actionType.type());
        Integer chance = root.optional("chance").map(Tag::getAsInt).orElse(100);
        ClickAction action = ClickAction.create(actionType, clickTypes, input);
        action.setChance(chance);
        action.setCooldown(cooldown);
        action.setPermission(permission);
        return action;
    }

    @Override
    public Tag serialize(ClickAction<?> action, TagSerializationContext context) throws ParserException {
        CompoundTag tag = CompoundTag.empty();
        if (action.getPermission() != null) {
            tag.add("permission", action.getPermission());
        }
        if (!action.getCooldown().isZero()) {
            tag.add("cooldown", action.getCooldown().toMillis());
        }
        tag.add("actionType", context.serialize(action.getActionType()));
        ListTag types = ListTag.of((int)8, (Tag[])new StringTag[0]);
        for (ClickType type : action.getClickTypes()) {
            types.add(StringTag.of(type.name()));
        }
        tag.add("clickTypes", types);
        tag.add("input", context.serialize(action.getInput()));
        tag.add("chance", action.getChance());
        return tag;
    }
}

