/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.equipment;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import net.thenextlvl.character.plugin.command.equipment.CharacterEquipmentCommand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterEquipmentSetCommand
extends SimpleCommand {
    private CharacterEquipmentSetCommand(CharacterPlugin plugin) {
        super(plugin, "set", null);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterEquipmentSetCommand command = new CharacterEquipmentSetCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(CharacterCommand.characterArgument(plugin).then(CharacterEquipmentCommand.equipmentSlotArgument().then(Commands.argument((String)"item", (ArgumentType)ArgumentTypes.itemStack()).executes((Command)command))));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Character character = (Character)context.getArgument("character", Character.class);
        EquipmentSlot slot = (EquipmentSlot)context.getArgument("equipment-slot", EquipmentSlot.class);
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        Boolean success = character.getEntity(LivingEntity.class).map(LivingEntity::getEquipment).map(equipment -> {
            equipment.setItem(slot, item, true);
            return true;
        }).orElse(false);
        String message = success == false ? "nothing.changed" : (item.isEmpty() ? "character.equipment.slot.cleared" : "character.equipment.slot");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.component((String)"item", (ComponentLike)item.effectiveName().hoverEvent((HoverEventSource)item.asHoverEvent())), Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"slot", (String)slot.name().toLowerCase().replace("_", "-"))});
        return success != false ? 1 : 0;
    }
}

