/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import net.thenextlvl.character.plugin.command.suggestion.CharacterWithActionSuggestionProvider;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterActionListCommand
extends SimpleCommand {
    private CharacterActionListCommand(CharacterPlugin plugin) {
        super(plugin, "list", "characters.command.action.list");
    }

    static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterActionListCommand command = new CharacterActionListCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(CharacterCommand.characterArgument(plugin).suggests(new CharacterWithActionSuggestionProvider(plugin)).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Character character = (Character)context.getArgument("character", Character.class);
        if (character.getActions().isEmpty()) {
            this.plugin.bundle().sendMessage((Audience)sender, "character.action.list.empty", new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName())});
            return 0;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "character.action.list.header", new TagResolver[]{Placeholder.parsed((String)"character", (String)character.getName())});
        character.getActions().forEach((name, action) -> this.plugin.bundle().sendMessage((Audience)sender, "character.action.list", new TagResolver[]{Placeholder.parsed((String)"action_type", (String)action.getActionType().name()), Placeholder.parsed((String)"character", (String)character.getName()), Placeholder.parsed((String)"action", (String)name)}));
        return 1;
    }
}

