/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Rotation;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.BrigadierCommand;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterTeleportCommand
extends BrigadierCommand {
    private CharacterTeleportCommand(CharacterPlugin plugin) {
        super(plugin, "teleport", "characters.command.teleport");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterTeleportCommand command = new CharacterTeleportCommand(plugin);
        ArgumentBuilder rotation = CharacterTeleportCommand.rotationArgument().executes(command::teleportPosition);
        ArgumentBuilder position = CharacterTeleportCommand.positionArgument().executes(command::teleportPosition);
        ArgumentBuilder entity = CharacterTeleportCommand.entityArgument().executes(command::teleportEntity);
        RequiredArgumentBuilder teleport = (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)CharacterCommand.characterArgument(plugin).executes(command::teleportSelf)).then(position.then(rotation))).then(entity);
        return (LiteralArgumentBuilder)command.create().then((ArgumentBuilder)teleport);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> entityArgument() {
        return Commands.argument((String)"entity", (ArgumentType)ArgumentTypes.entity());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> positionArgument() {
        return Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition((boolean)true));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> rotationArgument() {
        return Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation());
    }

    private int teleportSelf(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(sender instanceof Player)) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }
        Player player = (Player)sender;
        Character character = (Character)context.getArgument("character", Character.class);
        character.getEntity().map(Entity::getLocation).or(character::getSpawnLocation).ifPresent(location -> player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND, new TeleportFlag[]{TeleportFlag.EntityState.RETAIN_PASSENGERS}));
        this.plugin.bundle().sendMessage((Audience)sender, "character.teleported.self", new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName())});
        return 1;
    }

    private int teleportPosition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        FinePositionResolver resolver = (FinePositionResolver)context.getArgument("position", FinePositionResolver.class);
        RotationResolver rotationResolver = this.tryGetArgument(context, "rotation", RotationResolver.class).orElse(null);
        Rotation rotation = rotationResolver != null ? (Rotation)rotationResolver.resolve((CommandSourceStack)context.getSource()) : Rotation.rotation((float)0.0f, (float)0.0f);
        Location position = ((FinePosition)resolver.resolve((CommandSourceStack)context.getSource())).toLocation(((CommandSourceStack)context.getSource()).getLocation().getWorld());
        return this.teleport(context, position.setRotation(rotation));
    }

    private int teleportEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        EntitySelectorArgumentResolver selector = (EntitySelectorArgumentResolver)context.getArgument("entity", EntitySelectorArgumentResolver.class);
        Entity entity = (Entity)((List)selector.resolve((CommandSourceStack)context.getSource())).getFirst();
        return this.teleport(context, entity.getLocation());
    }

    private int teleport(CommandContext<CommandSourceStack> context, Location location) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Character character = (Character)context.getArgument("character", Character.class);
        character.getEntity().ifPresent(entity -> entity.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND, new TeleportFlag[]{TeleportFlag.EntityState.RETAIN_PASSENGERS}));
        boolean success = character.setSpawnLocation(location);
        String message = success ? "character.teleported" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"world", (String)location.getWorld().getName()), Formatter.number((String)"x", (Number)location.x()), Formatter.number((String)"y", (Number)location.y()), Formatter.number((String)"z", (Number)location.z()), Formatter.number((String)"yaw", (Number)Float.valueOf(location.getYaw())), Formatter.number((String)"pitch", (Number)Float.valueOf(location.getPitch())), Placeholder.unparsed((String)"character", (String)character.getName())});
        return success ? 1 : 0;
    }
}

