/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.goal.Goal;
import net.thenextlvl.character.tag.TagOptions;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Character<E extends Entity> {
    public Optional<ClickAction<?>> getAction(String var1);

    public @Unmodifiable Map<String, ClickAction<?>> getActions();

    public Optional<Component> getDisplayName();

    public @Unmodifiable Set<Goal> getGoals();

    public boolean addGoal(Goal var1);

    public boolean removeGoal(Goal var1);

    public <T> Optional<T> getEntity(Class<T> var1);

    public Optional<E> getEntity();

    public Class<? extends E> getEntityClass();

    public Optional<NamedTextColor> getTeamColor();

    public Optional<Location> getLocation();

    public String getName();

    public String getScoreboardName();

    public Optional<String> getViewPermission();

    public Optional<Location> getSpawnLocation();

    public TagOptions getTagOptions();

    public EntityType getType();

    public @Unmodifiable Set<UUID> getViewers();

    public Optional<World> getWorld();

    public Optional<Pathfinder> getPathfinder();

    @Contract(mutates="this")
    public <T> boolean addAction(String var1, ClickAction<T> var2);

    @Contract(mutates="this")
    public boolean addViewer(UUID var1);

    @Contract(mutates="this")
    public boolean addViewers(Collection<UUID> var1);

    public boolean canSee(Player var1);

    public boolean despawn();

    public boolean hasAction(ClickAction<?> var1);

    public boolean hasAction(String var1);

    public boolean isDisplayNameVisible();

    public boolean isPathfinding();

    public boolean isPersistent();

    public boolean isSpawned();

    public boolean isTrackedBy(Player var1);

    public boolean isViewer(UUID var1);

    public boolean isVisibleByDefault();

    @Contract(mutates="io,this")
    public boolean persist();

    @Contract(mutates="this")
    public boolean removeAction(String var1);

    @Contract(mutates="this")
    public boolean removeViewer(UUID var1);

    @Contract(mutates="this")
    public boolean removeViewers(Collection<UUID> var1);

    public boolean respawn();

    public boolean respawn(Location var1);

    @Contract(mutates="this")
    public boolean setDisplayName(@Nullable Component var1);

    @Contract(mutates="this")
    public boolean setDisplayNameVisible(boolean var1);

    @Contract(mutates="this")
    public boolean setPathfinding(boolean var1);

    @Contract(mutates="this")
    public boolean setPersistent(boolean var1);

    @Contract(mutates="this")
    public boolean setSpawnLocation(@Nullable Location var1);

    @Contract(mutates="this")
    public boolean setTeamColor(@Nullable NamedTextColor var1);

    @Contract(mutates="this")
    public boolean setViewPermission(@Nullable String var1);

    @Contract(mutates="this")
    public boolean setVisibleByDefault(boolean var1);

    public boolean spawn();

    public boolean spawn(Location var1);

    public void delete();

    public void remove();
}

