/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.serialization;

import com.destroystokyo.paper.profile.ProfileProperty;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ProfilePropertyAdapter
implements TagAdapter<ProfileProperty> {
    @Override
    public ProfileProperty deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        String name = root.get("name").getAsString();
        String value = root.get("value").getAsString();
        String signature = root.optional("signature").map(Tag::getAsString).orElse(null);
        return new ProfileProperty(name, value, signature);
    }

    @Override
    public Tag serialize(ProfileProperty property, TagSerializationContext context) throws ParserException {
        CompoundTag tag = CompoundTag.empty();
        tag.add("name", property.getName());
        tag.add("value", property.getValue());
        if (property.getSignature() != null) {
            tag.add("signature", property.getSignature());
        }
        return tag;
    }
}

